/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SSOPluginInfo {
    private String pluginKey;
    private String version;
    private String hostApplication;
    private String hostApplicationVersion;
    private String licenseType;
    private String licenseSize;
    private String maintenanceExpires;

    public SSOPluginInfo() {
    }

    public SSOPluginInfo(ApplicationProperties applicationProperties, PluginLicenseManager licenseManager, PluginAccessor pluginAccessor) {
        this();
        this.fill(applicationProperties, licenseManager, pluginAccessor);
    }

    public void fill(ApplicationProperties applicationProperties, PluginLicenseManager licenseManager, PluginAccessor pluginAccessor) {
        this.pluginKey = licenseManager.getPluginKey();
        if (licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)licenseManager.getLicense().get();
            this.licenseType = license.getLicenseType().toString();
            this.licenseSize = license.getEdition().isDefined() ? ((Integer)license.getEdition().get()).toString() : "UNLIMITED";
            this.maintenanceExpires = license.getMaintenanceExpiryDate().isDefined() ? ((DateTime)license.getMaintenanceExpiryDate().get()).toString() : "NEVER";
        } else {
            this.licenseType = "NONE";
            this.licenseSize = "NONE";
            this.maintenanceExpires = "NONE";
        }
        Plugin plugin = pluginAccessor.getPlugin(this.pluginKey);
        PluginInformation pluginInfo = plugin.getPluginInformation();
        this.version = pluginInfo.getVersion();
        this.hostApplication = applicationProperties.getDisplayName();
        this.hostApplicationVersion = applicationProperties.getVersion();
    }

    @XmlElement
    public String getPluginKey() {
        return this.pluginKey;
    }

    @XmlElement
    public String getPluginVersion() {
        return this.version;
    }

    @XmlElement
    public String getHostApplication() {
        return this.hostApplication;
    }

    @XmlElement
    public String getHostApplicationVersion() {
        return this.hostApplicationVersion;
    }

    @XmlElement
    public String getLicenseType() {
        return this.licenseType;
    }

    @XmlElement
    public String getLicenseSize() {
        return this.licenseSize;
    }

    @XmlElement
    public String getMaintenanceExpires() {
        return this.maintenanceExpires;
    }
}

