/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.resolution.atlasplugins.samlsso.PluginProperties;
import com.resolution.license.License;
import com.resolution.license.LicenseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    public static final Logger logger = LoggerFactory.getLogger(LicenseChecker.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginSettings pluginSettings;
    private final boolean atlassianLicense;
    private final boolean ownLicense;
    private final String serverId;

    public LicenseChecker(PluginLicenseManager pluginLicenseManager, LicenseHandler licenseHandler, PluginSettingsFactory pluginSettingsFactory) {
        logger.debug("Constructing LicenseChecker");
        this.serverId = licenseHandler.getServerId();
        logger.debug("Server ID is ==> " + licenseHandler.getServerId());
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        String licenseProp = PluginProperties.get("licensingEnabled");
        String ownLicenseProp = PluginProperties.get("ownLicensing");
        if (licenseProp != null && licenseProp.equalsIgnoreCase("true")) {
            this.atlassianLicense = true;
            logger.info("Atlassian licensing is enabled.");
        } else {
            this.atlassianLicense = false;
            logger.info("Atlassian licensing is disabled.");
        }
        if (ownLicenseProp != null && ownLicenseProp.equalsIgnoreCase("true")) {
            this.ownLicense = true;
            logger.info("Resolution licensing is enabled.");
        } else {
            this.ownLicense = false;
            logger.info("Resolution licensing is disabled.");
        }
    }

    public boolean isOwnLicense() {
        return this.ownLicense;
    }

    public boolean isAtlassianLicense() {
        return this.atlassianLicense;
    }

    public String getServerId() {
        return this.serverId;
    }

    private LicenseCheckResult checkAtlassianLicense() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                LicenseError error = (LicenseError)license.getError().get();
                if (error == LicenseError.VERSION_MISMATCH) {
                    logger.warn("================= License has a VERSION_MISMATCH =====================");
                    logger.warn("== It seems like this version has been built after your maintenance ==");
                    logger.warn("== expired, but in some cases, this is caused by an issue in the    ==");
                    logger.warn("== Atlassian license manager. The plugin will keep working, but     ==");
                    logger.warn("== you should check your license.                                   ==");
                    logger.warn("======================================================================");
                    return new LicenseCheckResult(true, "Atlassian license error: " + ((LicenseError)license.getError().get()).name(), false, true);
                }
                return new LicenseCheckResult(false, "Atlassian license error: " + ((LicenseError)license.getError().get()).name(), false, false);
            }
            if (license.isEvaluation()) {
                return new LicenseCheckResult(true, "Atlassian evaluation license found", true, false);
            }
            return new LicenseCheckResult(true, "Valid Atlassian license found");
        }
        return new LicenseCheckResult(false, "License error: no Atlassian license installed");
    }

    public LicenseCheckResult checkOwnLicense(String licenseString) {
        if (licenseString == null || licenseString.isEmpty()) {
            return new LicenseCheckResult(false, "License error: no Resolution license installed");
        }
        License license = LicenseFactory.loadLicenseFromString(licenseString);
        if (!license.isSignatureValid()) {
            return new LicenseCheckResult(false, "License error: License signature is invalid");
        }
        if (!license.isFeatureLicensed("samlsso")) {
            return new LicenseCheckResult(false, "License error: License does not contain the samlsso feature");
        }
        if (!license.isBeforeValidUntil()) {
            return new LicenseCheckResult(false, "License error: License is expired.");
        }
        if (!license.isValidForHost(this.serverId)) {
            return new LicenseCheckResult(false, "License error: Host id " + this.serverId + " does not match license");
        }
        return new LicenseCheckResult(true, "Resolution license for Server ID " + this.serverId + " is valid");
    }

    public LicenseCheckResult checkLicense() {
        if (this.ownLicense || this.atlassianLicense) {
            if (this.atlassianLicense) {
                LicenseCheckResult atlassianResult = this.checkAtlassianLicense();
                if (atlassianResult.isLicensed()) {
                    if (atlassianResult.isEvaluation() && this.ownLicense) {
                        String licenseString = (String)this.pluginSettings.get("com.resolution.atlasplugins.samlsso:licenseString");
                        LicenseCheckResult ownResult = this.checkOwnLicense(licenseString);
                        if (ownResult.isLicensed()) {
                            return ownResult;
                        }
                        return atlassianResult;
                    }
                    return atlassianResult;
                }
                if (this.ownLicense) {
                    String licenseString = (String)this.pluginSettings.get("com.resolution.atlasplugins.samlsso:licenseString");
                    LicenseCheckResult ownResult = this.checkOwnLicense(licenseString);
                    return ownResult;
                }
                return atlassianResult;
            }
            String licenseString = (String)this.pluginSettings.get("com.resolution.atlasplugins.samlsso:licenseString");
            return this.checkOwnLicense(licenseString);
        }
        return new LicenseCheckResult(true, "License is not enforced");
    }

    public class LicenseCheckResult {
        private boolean licensed;
        private String message;
        private boolean evaluation;
        private boolean warning;

        public LicenseCheckResult(boolean licensed, String message) {
            this(licensed, message, false, false);
        }

        public LicenseCheckResult(boolean licensed, String message, boolean evaluation, boolean warning) {
            this.licensed = licensed;
            this.message = message;
            this.evaluation = evaluation;
            this.warning = warning;
        }

        public boolean isLicensed() {
            return this.licensed;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isEvaluation() {
            return this.evaluation;
        }

        public boolean isWarning() {
            return this.warning;
        }
    }
}

