/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.service.rememberme.RememberMeService;
import com.resolution.atlasplugins.samlsso.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.AuthenticatorHookException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticatorHook
implements AuthenticatorHook {
    private final Logger logger = LoggerFactory.getLogger(AbstractAuthenticatorHook.class);

    protected abstract DefaultAuthenticator getAuthenticator();

    @Override
    public boolean logout(HttpServletRequest req, HttpServletResponse resp) throws AuthenticatorException {
        this.logger.debug("Calling Authenticator.logout()");
        return this.getAuthenticator().logout(req, resp);
    }

    protected boolean invokeAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User principal) throws AuthenticatorHookException {
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        String methodName = "authoriseUserAndEstablishSession";
        Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
        Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
        try {
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.getAuthenticator(), parameters);
            if (returnValue instanceof Boolean) {
                return (Boolean)returnValue;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName());
        }
        catch (NoSuchMethodException e) {
            throw new AuthenticatorHookException("Calling authoriseUserAndEstablishSession() via reflection failed.", e);
        }
        catch (SecurityException e) {
            throw new AuthenticatorHookException("Calling authoriseUserAndEstablishSession() via reflection failed.", e);
        }
        catch (IllegalAccessException e) {
            throw new AuthenticatorHookException("Calling authoriseUserAndEstablishSession() via reflection failed.", e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException("authoriseUserAndEstablishSession() threw exception", e.getCause());
        }
    }

    @Override
    public boolean authoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String userid, boolean setRememberMe) throws AuthenticatorHookException {
        boolean authenticated = this.doAuthoriseUserAndEstablishSession(httpServletRequest, httpServletResponse, userid);
        if (authenticated && setRememberMe) {
            this.addRememberMeCookie(httpServletRequest, httpServletResponse, userid);
        }
        return authenticated;
    }

    public abstract boolean doAuthoriseUserAndEstablishSession(HttpServletRequest var1, HttpServletResponse var2, String var3) throws AuthenticatorHookException;

    protected boolean addRememberMeCookie(HttpServletRequest request, HttpServletResponse response, String userid) {
        this.logger.debug("Setting rememberMeCookie for {}", (Object)userid);
        RememberMeService rememberMeService = null;
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        String methodName = "getRememberMeService";
        try {
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, new Class[0]);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.getAuthenticator(), new Object[0]);
            if (!(returnValue instanceof RememberMeService)) {
                this.logger.error("Authenticator method {} did not return a RememberMeService, but a {}", (Object)methodName, (Object)returnValue.getClass().getCanonicalName());
                return false;
            }
            rememberMeService = (RememberMeService)returnValue;
        }
        catch (NoSuchMethodException e) {
            this.logger.error("Calling {} via reflection failed", (Object)methodName, (Object)e);
            return false;
        }
        catch (SecurityException e) {
            this.logger.error("Calling {} via reflection failed", (Object)methodName, (Object)e);
            return false;
        }
        catch (IllegalAccessException e) {
            this.logger.error("Calling {} via reflection failed", (Object)methodName, (Object)e);
            return false;
        }
        catch (InvocationTargetException e) {
            this.logger.error("Calling {} via reflection failed", (Object)methodName, (Object)e.getCause());
            return false;
        }
        String addCookieMethodName = "addRememberMeCookie";
        Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class};
        Object[] parameters = new Object[]{request, response, userid};
        try {
            Class<?> rememberMeServiceClass = rememberMeService.getClass();
            this.logger.debug("Scanning methods for {}", (Object)rememberMeServiceClass.getCanonicalName());
            Method methodToInvoke = rememberMeServiceClass.getMethod(addCookieMethodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            methodToInvoke.invoke((Object)rememberMeService, parameters);
            this.logger.debug("Calling {} succeeded.", (Object)addCookieMethodName);
            return true;
        }
        catch (NoSuchMethodException e) {
            this.logger.error("Calling {} via reflection failed", (Object)addCookieMethodName, (Object)e);
            return false;
        }
        catch (SecurityException e) {
            this.logger.error("Calling {} via reflection failed", (Object)addCookieMethodName, (Object)e);
            return false;
        }
        catch (IllegalAccessException e) {
            this.logger.error("Calling {} via reflection failed", (Object)addCookieMethodName, (Object)e);
            return false;
        }
        catch (InvocationTargetException e) {
            this.logger.error("Calling {} via reflection failed", (Object)addCookieMethodName, (Object)e.getCause());
            return false;
        }
    }
}

