define("tc/ao-migration",
    [
        "jquery",
        "tc/util",
        "tc-backbone"
    ],
    function(
        $,
        UTIL,
        Backbone) {

        var AOMigrationTeamCalendar = Backbone.View.extend({
            el: "#ao-migration",

            initialize: function() {
                $progressbar.tcprogressbar({
                    value: false,
                    change: function() {
                        $progressLabel.text(Math.floor($progressbar.tcprogressbar( "value" )) + "%" );
                    },
                    complete: function() {
                        $progressLabel.text(AJS.I18n.getText("calendar3.admin.aomigration.processbar.complete"));
                        enableButtonAOMigration();
                    }
                });
            },

            events : {
                "click button.migrate":  "runMigration",
                "click button.force": "runForceData"
            },

            render: function() {
                if(AJS.params.statusAOMigration === 'RUNNING') {
                    disableButtonAOMigration();
                    //check status and get infor log
                    showProcessBar();
                } else {
                    enableButtonAOMigration();
                }
            },

            runMigration: function() {
                var data = callRestAOMigrationGetInfor();
                data.done(function(response){
                    var statusAOMigration = response.status;
                       if(statusAOMigration  === 'NOT_RUNNING') {
                           //clean log
                           cleanLog();
                           //call run ao migration
                           runAOMigration();
                       } else {
                           disableButtonAOMigration();
                       }
                });
            },

            runForceData: function() {
                disableButtonAOMigration();
                var confirmBox = confirm(AJS.I18n.getText("calendar3.admin.aomigration.box.force.info"));
                if (confirmBox === true) {
                    var loggingDiv = $("#ao-migration-log .logs-aomigration-container");
                    $("#ao-migration-log").removeClass("hidden");
                    $("#ao-migration-processbar").addClass("hidden");
                    loggingDiv.html(AJS.I18n.getText("calendar3.admin.aomigration.info.force.process"));
                    var resultDelete = callRestAOMigrationToDeleteData();
                    resultDelete.done(function(response) {
                        loggingDiv.empty();
                        if(response.success === true) {
                            loggingDiv.html(AJS.I18n.getText("calendar3.admin.aomigration.info.force.success"));
                        } else {
                            loggingDiv.html(AJS.I18n.getText("calendar3.admin.aomigration.info.force.fail"));
                        }
                        enableButtonAOMigration();
                    });
                } else {
                    enableButtonAOMigration();
                }
            }
        });

        var $progressbar = $("#tc-progressbar"),
            $progressLabel = $("#ao-migration-processbar .progress-label");

        var idInterval;

        function showProcessBar() {
               $("#ao-migration-processbar").removeClass("hidden");
               //reset process bar
               if($progressbar.tcprogressbar("value") === 100) {
                   $progressbar.tcprogressbar("value", 0);
               }
               setTimeout(progress, 1000);
        }

        function progress() {
            idInterval = setInterval(function() {
                var val = $progressbar.tcprogressbar("value") || 0;
                if ( val < 99 ) {
                    var data = callRestAOMigrationGetInfor();
                    data.done(function(response){
                        if(response.messages !== undefined) {
                          showInforLog(response.messages);
                        }
                    });
                }
                else {
                    clearInterval(idInterval);
                }
            }, 1000);
        }

        function showInforLog(messages) {
            $("#ao-migration-log").removeClass("hidden");
            $.each(messages, function(index, value) {
                $("#ao-migration-log .logs-aomigration-container").append("<p>" + value.message + "</p>");
                $progressbar.tcprogressbar( "value", value.percentage * 100 );
            });

        }

        function disableButtonAOMigration() {
            $("button", "#ao-migration").attr("disabled", "disabled");
        }

        function enableButtonAOMigration() {
            $("button", "#ao-migration").removeAttr('disabled');
        }

        function callRestAOMigrationGetInfor() {
            var defer;
            defer = AJS.safe.ajax({
                data: {},
                type : "GET",
                url : UTIL.getRestBaseUrl() + "/migration/ao/status"
            });
            return defer;
        }

        function cleanLog() {
            $("#ao-migration-log .logs-aomigration-container").html("");
            $("#ao-migration-log").addClass("hidden");
        }

        function runAOMigration() {
            AJS.safe.ajax({
                data: {},
                contentType: "application/json",
                success: function(response) {
                    if(response.success === true) {
                        //disable button ao-migration
                        disableButtonAOMigration();
                        //show process and get infor log
                        showProcessBar();
                    } else {
                        enableButtonAOMigration();
                    }
                },
                type : "POST",
                url : UTIL.getRestBaseUrl() + "/migration/ao/run"
            });
        }

        function callRestAOMigrationToDeleteData() {
            return AJS.safe.ajax({
                data: {},
                contentType: "application/json",
                type : "DELETE",
                url : UTIL.getRestBaseUrl() + "/migration/ao/force"
            });
        }

        return AOMigrationTeamCalendar;
});
