jQuery(function($) {

    $("button.reindex", "#reindex-calendar-contenttype").bind("click", function() {
        disableButtonReIndex();
        var loggingDiv = $("#logs-reindex-calendar-contenttype");
            loggingDiv.html(Confluence.TeamCalendars.Templates.reindexContentType({"status": "process"}));

        var resultReindex = callRestReindexCalendarContentType();
        resultReindex.done(function(response) {
            loggingDiv.empty();
            if(response.success === true) {
                loggingDiv.html(Confluence.TeamCalendars.Templates.reindexContentType({"status": "success"}));
            } else {
                loggingDiv.html(Confluence.TeamCalendars.Templates.reindexContentType({"status": "fail"}));
            }
            enableButtonReIndex();
        });
    });

    function callRestReindexCalendarContentType() {
        return AJS.safe.ajax({
            data: {},
            contentType: "application/json",
            type : "POST",
            url : Confluence.TeamCalendars.getRestBaseUrl() + "/calendarcontenttype/reindex"
        });
    }

    function disableButtonReIndex() {
        $("button", "#reindex-calendar-contenttype").attr("disabled", "disabled");
    }

    function enableButtonReIndex() {
        $("button", "#reindex-calendar-contenttype").removeAttr('disabled');
    }

});