;(function($) {
    var initTeamCalendarsMacroForBrowser = function() {
        setOverrides("space-calendar")();
        setOverrides("team-calendar")();
        setOverrides("calendar")();
    };

    function getOpenerOverride(macroName) {
        return function(macro) {
            if(macro.params) {
                //HACK! - This seems very fragile. Is there a better way to do it?
                //What we do here is remove the 'opener' override and reopen the macro browser
                //We use the 'postPreview' override to re-add the 'opener' override after the browser has opened
                AJS.MacroBrowser.setMacroJsOverride(macroName, {
                    opener : null,
                    fields : getFieldsOverride(),
                    postPreview : setOverrides(macroName)});
                tinymce.confluence.macrobrowser.editMacro(AJS.Editor.Adapter.getEditor().selection.getNode());
            } else {
                Confluence.TeamCalendars.Dialogs.getAddDialogForMacro(macro);
            }
        }
    }

    function setOverrides(macroName) {
        return function() {
            AJS.MacroBrowser.setMacroJsOverride(macroName, {opener : getOpenerOverride(macroName), fields : getFieldsOverride()});
        }
    }

    function getFieldsOverride() {
        return {
            "string" : {
                "id" : function(param, options) {

                    var parameterContainer;

                    // we need to put some logic here to TC compatible with older version of AJS.MacroBrowser
                    if (AJS.MacroBrowser.makeParameterDiv)
                    {
                        // Deal with older version of AJS.MacroBrowser
                        parameterContainer = AJS.MacroBrowser.makeParameterDiv({}, { name: "id", type: "string" });
                    }
                    else
                    {
                        // Deal with latest version of AJS.MacroBrowser
                        parameterContainer = AJS.MacroBrowser.ParameterFields["string"](param, options).paramDiv;
                    }

                    var subCalendarSelect = $("<input/>", { "class" : "subcalendars-select", "type" : "hidden" });
                    var subCalendarsInput = $("input", parameterContainer).addClass("hidden").after(subCalendarSelect);
                    var setValue = function(subCalendarIds) {
                        if (subCalendarIds) {
                            var subCalendarIdsString = $.isArray(subCalendarIds) ? subCalendarIds.join(",") : subCalendarIds;
                            subCalendarsInput.val(subCalendarIdsString);

                            if (!subCalendarsInput.data("renderedInitialSelection")) {
                                subCalendarsInput.data("renderedInitialSelection", true); // Stop it from re-rendering user selections

                                $.ajax({
                                    cache: false,
                                    data : { subCalendarIds : subCalendarIdsString },
                                    dataType: "json",
                                    success : function(subCalendars) {
                                        if (subCalendars && $.isArray(subCalendars)) {
                                            subCalendarSelect.auiSelect2("data", $.map(subCalendars, function(aSubCalendar) {
                                                return {
                                                    "id" : aSubCalendar.id,
                                                    "text" : $("<span/>",  { "text" : aSubCalendar.name }).html()
                                                }
                                            }));
                                        }
                                    },
                                    timeout : Confluence.TeamCalendars.ajaxTimeout,
                                    url : AJS.contextPath() + "/rest/calendar-services/1.0/calendar/util/format/subcalendar/ids.json"
                                });
                            }
                        } else {
                            subCalendarsInput.val("");
                        }

                        subCalendarsInput.trigger("change");
                    };

                    subCalendarSelect.change(function() {
                        setValue($.trim(subCalendarSelect.auiSelect2("val")));
                    }).auiSelect2({
                        "minimumInputLength" : 1,
                        "formatNoMatches" : function(searchTerm) {
                            return $("<div/>").append(
                                    $("<span/>", { "text" : AJS.format(AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.param.id.calendarnotfound"), searchTerm || "")})
                            ).html();
                        },
                        "formatInputTooShort" : function() {
                            return $("<div/>").append(
                                    $("<span/>", { "text" : AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.param.id.searchquerytooshort") })
                            ).html();
                        },
                        "multiple" : true,
                        "query" : function(options) {
                            $.ajax({
                                "cache" : false,
                                "data":  {
                                    term: options.term,
                                    limit: 5,
                                    showSubCalendarsInView : "true"
                                },
                                "dataType" : "json",
                                "success" : function(searchResults) {
                                    options.callback({
                                        "results" : (function() {
                                            if (searchResults.payload && searchResults.payload.length) {
                                                return $.map(searchResults.payload, function(payload) {
                                                    return {
                                                        "id" : payload.subCalendar.id,
                                                        "text" : $("<span/>", { "text" : payload.subCalendar.name }).html()
                                                    }
                                                });
                                            }

                                            return [];
                                        })(),
                                        "more" : false
                                    });
                                    //HACK - work around for CONFDEV-15071
                                    $(".select2-drop-active").addClass("select2-drop");
                                },
                                timeout : Confluence.TeamCalendars.ajaxTimeout,
                                "url" : AJS.contextPath() + "/rest/calendar-services/1.0/calendar/search/subcalendars.json"
                            })
                        }
                    });

                    $(".select2-container", parameterContainer).after(
                        $("<div/>", { "class" : "id-desc", "html" : AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.param.id.desc") }
                        ).click(function() {
                                AJS.MacroBrowser.close();
                                Confluence.TeamCalendars.Dialogs.getAddDialogForMacro({
                                    name: $("#macro-insert-container .macro-name").val(),
                                    params: (function() {
                                        var _theParams = {};
                                        $(".macro-param-input").each(function() {
                                                var aParam = $(this);
                                                _theParams[aParam.attr("id").substring(12)] = aParam.attr("type") === "checkbox" ? aParam.prop("checked") : aParam.val()
                                        });

                                        return _theParams;
                                    })(),
                                    defaultParameterValue: ""
                                });
                        })
                    );

                    return AJS.MacroBrowser.Field(parameterContainer, subCalendarsInput, $.extend({
                        setValue : function(value) {
                            setValue(value);
                        }
                    }), options);
                }
            }
        }
    }

    AJS.bind("init.rte", initTeamCalendarsMacroForBrowser);
})(jQuery);
