define("tc/non-space-calendars-dialog-view",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "ajs",
        "tc/calendar-util",
        "tc/non-space-calendar-entry-view"
    ],
    function (
        $,
        _,
        Backbone,
        AJS,
        CalUtil,
        NonSpaceCalendarEntryView
    ) {

        "use strict";

        var dialog;

        var NonSpaceCalendarsDialogView = Backbone.View.extend({

            events: {},

            initialize: function (options) {
                this.subCalendars = options.subCalendars;
                this.nonSpaceCalendarEntryViews = [];

                this.CalendarPlugin = options.CalendarPlugin;
                this.calendarDiv = options.calendarDiv;
                this.cache = options.cache;
            },

            setSubCalendars: function (subCalendars) {
                this.subCalendars = subCalendars;
            },

            render: function () {
                if (!dialog) {
                    dialog = this.dialog = new AJS.Dialog(600, 600, "non-space-calendars-dialog");

                    var title = AJS.I18n.getText("calendar3.non.space.dialog.header");
                    dialog.addHeader(title);

                    dialog.addPanel(
                            title,
                            Confluence.TeamCalendars.Templates.nonSpaceCalendarsDialog(),
                            "non-space-calendars-panel"
                    );

                    dialog.addSubmit(AJS.I18n.getText("calendar3.non.space.calendars.save"), _.bind(this._onSubmit, this));

                    dialog.addCancel(AJS.I18n.getText("calendar3.non.space.calendars.cancel"), _.bind(this._onCancel, this));

                    this.setElement(dialog.getCurPanel().body);
                }

                this._renderNonSpaceCalendarEntries();

                dialog.show();
            },

            _renderNonSpaceCalendarEntries: function () {
                this.nonSpaceCalendarEntryViews = [];
                this.$(".non-space-calendars-list").empty();

                _.each(this.subCalendars, _.bind(function (subCalendar) {
                    var nonSpaceCalendarEntryView = new NonSpaceCalendarEntryView({
                        subCalendar: subCalendar,
                        CalendarPlugin: this.CalendarPlugin,
                        calendarDiv: this.calendarDiv,
                        cache: this.cache
                    });

                    this.nonSpaceCalendarEntryViews.push(nonSpaceCalendarEntryView);
                    this.$(".non-space-calendars-list").append(nonSpaceCalendarEntryView.render());

                }, this));
            },

            _onSubmit: function () {
                var defers = [];

                _.each(this.nonSpaceCalendarEntryViews, function (view) {
                    var defer = view.updateSubCalendar("onSubmit");
                    if (defer !== undefined) {
                        defers.push(defer);
                    }
                });

                // wait for all update tasks to be completed then close dialog if all task are successful
                $.when.apply($, defers).done(_.bind(function () {
                    var allDone = true;
                    _.each(this.nonSpaceCalendarEntryViews, function (view) {
                        if (!view.isUpdateSuccessfully()) {
                            allDone = false;
                        }
                    });

                    if (allDone) {
                        this.CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(this.calendarDiv);
                        dialog.hide();

                        CalUtil.fireEventForAnalytics("non.space.calendars.upgrade.all.calendars.successful");
                    }
                }, this));

                CalUtil.fireEventForAnalytics("non.space.calendars.upgrade.dialog.submit.click");

                return false;
            },

            _onCancel: function () {
                var isChanged = false;

                _.each(this.nonSpaceCalendarEntryViews, function (view) {
                    if (view.isUpdateSuccessfully()) {
                        isChanged = true;
                    }
                });

                if (isChanged) {
                    this.CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(this.calendarDiv);
                }

                dialog.hide();

                CalUtil.fireEventForAnalytics("non.space.calendars.upgrade.dialog.cancel.click");

                return false;
            }

        });

        return NonSpaceCalendarsDialogView;
    }
);