define("tc/calendar-remove-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util",
        "tc/util"
    ], function
    (
        $,
        _,
        Backbone,
        Templates,
        CalUtil,
        Util
    )
    {
        "use strict";
        var CalendarRemoveDialog = Backbone.View.extend({
            removeSubCalendarDialog : null,
            calendarDiv: null,
            subCalendar: null,
            calendarPlugin : null,
            initialize: function(options){
                this.calendarDiv = options.calendarDiv;
                this.subCalendar = options.subCalendar;
                this.calendarPlugin = options.calendarPlugin;

                this.removeSubCalendarDialog = $('#remove-calendar-dialog');
            },
            render: function() {
                var that = this;
                var height;
                var inSpace = AJS.Meta.get("space-key") !== undefined || $("meta[name='ajs-page-id']").length >= 1;

                if (this.removeSubCalendarDialog) {
                    this.removeSubCalendarDialog.remove();
                }

                height = CalUtil.isPDLEnabled() ? 230: 200;
                this.removeSubCalendarDialog = new AJS.Dialog({
                    width : 512,
                    height : height,
                    id : 'remove-calendar-dialog'
                });

                this.removeSubCalendarDialog.addHeader(AJS.I18n.getText("calendar3.heading.removesubcalendar"),
                    "subcalendar-remove-header calendar-dialog-panel");
                this.removeSubCalendarDialog.addPanel(
                    "subcalendar-remove-calendar",
                    Templates.removeSubCalendar({inSpace: inSpace}),
                    "remove-subcalendar-form");

                // TEAMCAL-1608 will using css to create ellipsis for subCalendar.name
                var calendarToRemoveSpan = $('.calendar-to-remove', this.removeSubCalendarDialog.getPanel());
                calendarToRemoveSpan.attr("title", this.subCalendar.name);
                calendarToRemoveSpan.text(this.subCalendar.name);

                this.removeSubCalendarDialog.addButton(AJS.I18n.getText("ok"), function() {
                    if ($('#deletecalendaroption:checked', that.removeSubCalendarDialog.getPanel()).length) {
                        that.calendarPlugin.deleteSubCalendar(that.calendarDiv, that.subCalendar);
                    }
                    else { //otherwise we want to remove the calendar from our view
                        that.calendarPlugin.unsubscribeFromSubcalendar(that.calendarDiv, that.subCalendar);
                    }
                    that.removeSubCalendarDialog.hide();
                });

                this.removeSubCalendarDialog.addLink(AJS.I18n.getText("cancel.name"), function(){
                    that.removeSubCalendarDialog.hide();
                });

                this.removeSubCalendarDialog.show();
            }

        });

        return CalendarRemoveDialog;
    });