define("tc/calendar-ical-address-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util",
        "tc/util",
        "tc/calendar-reset-url-dialog",
        "tc/calendar-basic-auth-ical-address-dialog"
    ], function
        (
            $,
            _,
            Backbone,
            Templates,
            CalUtil,
            Util,
            CalendarResetUrlDialog,
            CalendarBasicAuthIcalAddressDialog
            )
    {
        "use strict";
        var CalendarIcalAddressDialog = Backbone.View.extend({
            calendarDiv: null,
            subCalendar: null,
            calendarPlugin : null,
            editDialog: null,
            $icalAddressField: null,
            initialize: function(options){
                this.calendarDiv = options.calendarDiv;
                this.subCalendar = options.subCalendar;
                this.calendarPlugin = options.calendarPlugin;
                this.editDialog = options.editDialog;

                this.$el.html(Templates.subCalendarPrivateUrlSubscribe({
                    "elementIdSuffix" : CalUtil.getParameter(this.calendarDiv, "elementIdSuffix")
                }));
                this.editDialog.addPanel(AJS.I18n.getText("calendar3.subscribe"), this.$el, "calendar-ical-subscription-dialog-panel");
            },
            render: function() {
                var that = this;
                var isPrivateUrlsEnabled = that.calendarPlugin.getParameter(that.calendarDiv, "privateUrlsEnabled") === "true";

                if (isPrivateUrlsEnabled) {
                    that._renderPrivateUrlSubscription();
                } else {
                    that._renderBasicUrlSubscription();
                }

                //process behaviour when share panel active
                this.editDialog.getCurrentPanel().onselect = function() {
                    $("#edit-calendar-dialog").find(".button-panel-button.submit").addClass("hidden");
                    that.focusToIcalField();
                };

                return this.editDialog;
            },

            _renderBasicUrlSubscription : function() {
                var calendarBasicAuthIcalAddressDialog = new CalendarBasicAuthIcalAddressDialog (
                    {
                        editDialog: this.editDialog,
                        subCalendar: this.subCalendar,
                        calendarPlugin: this.calendarPlugin,
                        calendarDiv: this.calendarDiv,
                        el: this.$el
                    }
                );

                calendarBasicAuthIcalAddressDialog.render();
                this.$icalAddressField = calendarBasicAuthIcalAddressDialog.$icalAddressField;
            },

            _renderPrivateUrlSubscription : function() {
                var that = this;
                var showGoogleButton = that.calendarPlugin.isHttpsServer(that.calendarDiv),
                    closeDialog = function() {
                        that.editDialog.hide();
                        that.editDialog.remove();
                    };

                var subscriptionDialogBody = this.$el;
                that.$icalAddressField =  $(".ical-address-field", subscriptionDialogBody);

                $(".reset-subscription-url", subscriptionDialogBody).click(function() {
                    closeDialog();
                    var calendarResetUrlDialog = new CalendarResetUrlDialog(
                        {
                            calendarPlugin : that.calendarPlugin,
                            calendarDiv: that.calendarDiv,
                            subCalendar: that.subCalendar});
                    calendarResetUrlDialog.render();
                    return false;
                });

                if (!showGoogleButton) {
                    $(".subscribe-or", subscriptionDialogBody).remove();
                    $(".subscribe-google-calendar", subscriptionDialogBody).remove();
                }

                var spinnerDefer = that.calendarPlugin.setSubCalendarSpinnerIconVisible(true);
                $.ajax({
                    cache: false,
                    success: function(data) {
                        $(".ical-address-field", subscriptionDialogBody).val(data).focus().select();
                        //Add google calendar link
                        if (showGoogleButton) {
                            $("a.subscribe-google-calendar", subscriptionDialogBody).attr({
                                "href": "https://www.google.com/calendar/render?cid=" + encodeURIComponent(data),
                                "title": AJS.format(AJS.I18n.getText("calendar3.privateurl.google.tooltip"), that.subCalendar.name)
                            });
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        that.calendarPlugin.showAjaxError(
                            that.calendarDiv,
                            XMLHttpRequest,
                            textStatus,
                            errorThrown,
                            that.calendarPlugin.ERROR_CLASS_PRIVATE_URL
                        );
                    },
                    complete: function(){
                        if (spinnerDefer) spinnerDefer.resolve();
                    },
                    type: "GET",
                    timeout: CalUtil.ajaxTimeout,
                    url: that.calendarPlugin.getCalendarServiceBaseUrl(
                        that.calendarDiv,
                            "/subcalendar/privateurl/" + encodeURIComponent(that.subCalendar.id))
                });

            },
            focusToIcalField : function(){
                this.$icalAddressField.focus().select();
            }

        });

        return CalendarIcalAddressDialog;
    });