define("tc/calendar-basic-auth-ical-address-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util",
        "tc/util"
    ], function
        (
            $,
            _,
            Backbone,
            Templates,
            CalUtil,
            Util
            )
    {
        "use strict";
        var CalendarBasicAuthIcalAddressDialog = Backbone.View.extend({
            calendarBasicAuthIcalAddressDialog : null,
            calendarDiv: null,
            subCalendar: null,
            calendarPlugin : null,
            editDialog: null,
            $icalAddressField: null,
            initialize: function(options){
                this.calendarDiv = options.calendarDiv;
                this.subCalendar = options.subCalendar;
                this.calendarPlugin = options.calendarPlugin;
                this.editDialog = options.editDialog;
                this.$el = options.el;

                this.$el.html(Templates.subCalendarBasicAuthSubscribe({ "elementIdSuffix" : CalUtil.getParameter(this.calendarDiv, "elementIdSuffix")}));
            },
            render: function() {
                var that = this;
                that.$icalAddressField = $(".ical-address-basic-field", this.$el);
                that.$icalAddressField.val(
                        CalUtil.getParameter(that.calendarDiv, "baseUrl") + "/rest/calendar-services/1.0/calendar/export/subcalendar/" + encodeURIComponent(that.subCalendar.id) + ".ics?os_authType=basic&isSubscribe=true"
                );
            }

        });

        return CalendarBasicAuthIcalAddressDialog;
    });
