/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.index.api;

public class FieldDescriptor {
    private final String name;
    private final String value;
    private final Index index;
    private final Store store;

    public FieldDescriptor(String name, String value, Store store, Index index) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is required.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is cannot be null.");
        }
        if (store == null) {
            throw new IllegalArgumentException("store is required.");
        }
        if (index == null) {
            throw new IllegalArgumentException("index is required.");
        }
        this.name = name;
        this.value = value;
        this.store = store;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Index getIndex() {
        return this.index;
    }

    public Store getStore() {
        return this.store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDescriptor that = (FieldDescriptor)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.store != that.store) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.store.hashCode();
        return result;
    }

    public static enum Store {
        NO,
        YES;

    }

    public static enum Index {
        NO,
        ANALYZED,
        NOT_ANALYZED;

    }
}

