
jQuery(function($) {

    if ($("#dashboard-get-started").length > 0)
    {
        $("#dashboard-get-started").parent().after($(".dashboard-calendar-container").children());
    }
    else
    {
        $(".welcome-message").after($(".dashboard-calendar-container").children());
    }


    var UpcomingEvents = {
        initializeAddLater : function(dashboardCalendar, fadeSpeed) {
            var suppressShowingLargeSadCalendar = function() {
                $.ajax({
                    cache: false,
                    data: {
                        messageKey : "MESSAGE_KEY_FULL_SIZED_EMPTY_UPCOMING_EVENTS"
                    },
                    error: function() {
                        $(".show-small-sad-calendar-error", dashboardCalendar).removeClass("hidden");
                    },
                    type: "DELETE",
                    timeout: Confluence.TeamCalendars.ajaxTimeout,
                    url : $("#confluence-context-path").attr("content") + "/rest/calendar-services/1.0/calendar/preferences/messagekey.json"
                });
            };

            $(".add-later", dashboardCalendar).click(function() {
                var sadCalendar = $(".sad-calendar", dashboardCalendar);
                sadCalendar.fadeTo(fadeSpeed, 0, function() {
                    sadCalendar.addClass("small-sad-calendar").fadeTo(fadeSpeed, 1);
                    suppressShowingLargeSadCalendar();
                });

                return false;
            });
        },

        initialize : function(dashboardCalendar) {
            this.initializeAddLater(dashboardCalendar, "fast");
        }
    };

    $(".dashboard-calendar").each(function() {
        UpcomingEvents.initialize($(this));
    });
});
