;(function($) {
    var initTeamCalendarsAutoConvert = function() {
        if (window.tinymce
                && window.tinymce.plugins
                && window.tinymce.plugins.Autoconvert
                && window.tinymce.plugins.Autoconvert.autoConvert
                && window.tinymce.plugins.Autoconvert.autoConvert.addHandler && $.isFunction(window.tinymce.plugins.Autoconvert.autoConvert.addHandler)) {
            window.tinymce.plugins.Autoconvert.autoConvert.addHandler(function(uri, node, done) {
                var queryKey = uri.queryKey || {};
                var subCalendarId = queryKey.subCalendarId ? queryKey.subCalendarId : queryKey.calendarId;
                var isDetailPage = /display\/(.*)\/calendar\/(.*)/.test(uri.path);

                if (isDetailPage){
                    var groups = /display\/(.*)\/calendar\/(.*)/.exec(uri.path);
                    subCalendarId = groups[2] ? groups[2] : "unknown";
                }

                if ((/\/calendar\/previewcalendar.action$/.test(uri.path)
                        || /\/calendar\/calendarPage.action$/.test(uri.path)
                        || isDetailPage)
                        && subCalendarId) {
                    window.tinymce.plugins.Autoconvert.convertMacroToDom(
                            {
                                name: "calendar",
                                params: {
                                    "id" : subCalendarId
                                }
                            },
                            done,
                            done);
                } else {
                    return done();
                }
            });
        }
    };

    $(initTeamCalendarsAutoConvert); // Backwards compatibility
    AJS.bind("init.rte", initTeamCalendarsAutoConvert);

})(jQuery);
