(function($) {
    Confluence.TeamCalendars.getRemoveJiraEventsDialog = function(CalendarPlugin, calendarDiv, childSubCalendar) {
        var dialog;

        dialog = new AJS.Dialog(400, 250);

        dialog.addHeader(AJS.I18n.getText("calendar3.heading.confirmremovejiraevents"));

        dialog.addPanel(
                "",
                Confluence.TeamCalendars.Templates.confirmRemoveJiraEvents({
                    childName : childSubCalendar.name,
                    parentName : CalendarPlugin.getSubCalendar(calendarDiv, childSubCalendar.parentId).name
                }),
                "remove-jira-events-confirmation-panel");

        dialog.addButton(
                AJS.I18n.getText("calendar3.removejiraevents.confirm"),
                function() {
                    removeJiraEvents();
                    dialog.remove();
                });

        dialog.addCancel(
                AJS.I18n.getText("cancel.name"),
                function() {
                    dialog.remove();
                });

        dialog.show();

        function removeJiraEvents() {
            var spinnerDefer = CalendarPlugin.setSubCalendarSpinnerIconVisible(calendarDiv, true);
            var resolveSpinner = function(){
                if (spinnerDefer) spinnerDefer.resolve();
            };
            CalendarPlugin.setProcessingSubCalendar(calendarDiv, true);
            CalendarPlugin._deleteSubCalendarInternal(
                    calendarDiv,
                    childSubCalendar.subscriptionId || childSubCalendar.id,
                    function (XMLHttpRequest, textStatus, errorThrown) {
                        CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                        resolveSpinner();
                        CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                    },
                    function (responseEntity) {
                        CalendarPlugin.removeSubCalendarEventSource(calendarDiv, childSubCalendar.id);
                        CalendarPlugin.setSubCalendars(calendarDiv, responseEntity.payload);
                        CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                        resolveSpinner();
                        CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                    }
            );
        }
    };
}(AJS.$));