define(
    'tc/calendar-plugin',
    [
        "jquery",
        "underscore",
        "ajs",
        "tc/calendar-cache",
        "tc/util",
        "tc/calendar-util",
        "tc/manage-event",
        "tc/manage-i18n-text",
        "tc/full-calendar-option",
        "tc/subcalendar-panel",
        "tc/auto-complete-search-helper",
        "tc/calendar-remove-dialog",
        "tc/calendar-feature-discovery-dialog",
        "tc/calendar-share-dialog",
        "tc/calendar-restriction-dialog",
        "tc/myCalendarTour",
        "tc/subcalendar-navigation-buttons-view",
        "tc/subcalendar-restriction-button-view",
        "tc/load-favicon"
    ],
    function(
        $,
        _,
        AJS,
        CalendarCache,
        Util,
        CalUtil,
        ManageEvent,
        ManageI18nText,
        FullCalendarOption,
        SubCalendarPanel,
        AutoCompleteSearchHelper,
        CalendarRemoveDialog,
        CalendarFeatureDiscoveryDialog,
        CalendarShareDialog,
        RestrictionDialog,
        CalendarTour,
        CalendarNavigationButtonsView,
        CalendarRestrictionButtonsView,
        Favicon)
    {
        "use strict";
        var cache = new CalendarCache();

        var CalendarPlugin = {
            spinnerDeferTasks : [],
            ajaxTimeout : Confluence.TeamCalendars.ajaxTimeout,
            i18nMessages : null,
            dialogSequence : 0,
            ERROR_CLASS_EVENT_UPDATE : "error-event-update",
            ERROR_CLASS_EVENT_DELETE : "error-event-delete",
            ERROR_CLASS_SUB_CALENDAR_LIST : "error-subcalendar-refresh",
            ERROR_CLASS_SUB_CALENDAR_DELETE : "error-subcalendar-delete",
            ERROR_CLASS_SUB_CALENDAR_UPDATE : "error-subcalendar-update",
            ERROR_CLASS_SUB_CALENDAR_WATCH : "error-subcalendar-watch",
            ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS : "error-subcalendar-list-events-",
            ERROR_CLASS_SUB_CALENDAR_TOGGLE_EVENTS : "error-subcalendar-toggle-events-",
            ERROR_CLASS_CONFIG_UPDATE : "error-config-update",
            ERROR_CLASS_PRIVATE_URL : "error-private-url",
            ERROR_CLASS_RESET_PRIVATE_URLS : "error-reset-private-urls",
            PREF_LAST_ALL_DAY_USED : "pref-all-day-event-default",

            init : function(calendarDiv) {
                var fullCalendarOptions = new FullCalendarOption(CalendarPlugin, calendarDiv, cache);

                if (CalendarPlugin.getParameter(calendarDiv, "width")) {
                    calendarDiv.parent().css("width", CalendarPlugin.getParameter(calendarDiv, "width") + "px");
                }

                if (CalendarPlugin.getParameter(calendarDiv, "height")) {
                    fullCalendarOptions.height = parseInt(CalendarPlugin.getParameter(calendarDiv, "height"));
                } else {
                    fullCalendarOptions.aspectRatio = 1.9;
                }

                if(CalendarPlugin.getParameter(calendarDiv, "displayWeekNumber"))
                {
                    fullCalendarOptions.weekNumbers = (CalendarPlugin.getParameter(calendarDiv, "displayWeekNumber") === "true");
                }

                this.getCalendarPanel(calendarDiv).fullCalendar(fullCalendarOptions);
                this.initCalendarDiv(calendarDiv);
            },

            getEventTypeNames : function (key){
                return ManageI18nText(this.i18nMessages).getEventTypeNames(key);
            },

            getMonthNames : function() {
                return ManageI18nText(this.i18nMessages).getMonthNames();
            },

            getMonthNamesShort : function() {
                return ManageI18nText(this.i18nMessages).getMonthNamesShort();
            },

            getDayNames : function() {
                return ManageI18nText(this.i18nMessages).getDayNames();
            },

            getDayNamesShort : function() {
                return ManageI18nText(this.i18nMessages).getDayNamesShort();
            },

            hideInlineAuiDialogs : function() {
                $("body").trigger("click");
            },

            isEventToolTipSuppressed : function(calendarDiv) {
                return calendarDiv.data("shouldSuppressEventToolTip");
            },

            setSuppressEventToolTip: function(calendarDiv, shouldSuppressEventToolTip) {
                calendarDiv.data("shouldSuppressEventToolTip", shouldSuppressEventToolTip);
            },

            setEventTooltipVisible : function(calendarDiv, event, jsEvent, visible) {
                if (visible && (this.isEventEditable(calendarDiv, event) || event.workingUrl)) {
                    var toolTip = $("body > .event-tooltip").length
                        ? $("body > .event-tooltip")
                        : $("<div/>", { "class" : "event-tooltip"}).appendTo($("body"));
                    $("p", toolTip).remove();

                    if (this.isEventEditable(calendarDiv, event))
                        toolTip.append($("<p/>", { "text" : AJS.I18n.getText("calendar3.shiftclickeventotedit.tooltip") }));

                    if (event.workingUrl)
                        toolTip.append(
                            $("<p/>", { "class" : "follow-hint", "text" : AJS.format(AJS.I18n.getText("calendar3.ctrlclicktofollowlink.tooltip"), event.workingUrl) })
                        );

                    toolTip.css({
                        "left": jsEvent.pageX + "px",
                        "top" : (jsEvent.pageY + 5) + "px"
                    }).show();

                } else {
                    $("body > .event-tooltip").hide();
                }
            },

            getParameter : function(calendarDiv, configKey) {
                return CalUtil.getParameter(calendarDiv, configKey);
            },

            getParameters : function(calendarDiv) {
                return CalUtil.getParameters(calendarDiv);
            },

            setParameter : function(calendarDiv, configKey, value) {
                CalUtil.setParameter(calendarDiv, configKey, value);
            },

            getCalendarPanel : function(calendarDiv) {
                return $(".calendar-panel .calendar", calendarDiv);
            },

            getTimelineHeight : function(calendarDiv) {
                return CalendarPlugin.getParameter(calendarDiv, "timelineHeight");
            },

            getMaxMonthToDisplayTimelineCalendar : function(calendarDiv) {
                return CalendarPlugin.getParameter(calendarDiv, "maxMonthToDisplayTimelineCalendar");
            },

            getDefaultStartTime : function(calendarDiv) {
                return this.getParameter(calendarDiv, "timeSuggestion")[16];
            },

            getDefaultEndTime : function(calendarDiv) {
                return this.getParameter(calendarDiv, "timeSuggestion")[18];
            },

            reloadSubCalendar : function(calendarDiv, subCalendarIds) {
                if (!subCalendarIds) {
                    return;
                }

                subCalendarIds = $.isArray(subCalendarIds) ? subCalendarIds : [ subCalendarIds ];

                $(".sub-calendar-panel .subcalendar-item", calendarDiv).each(function() {

                    var subCalendarEntry = $(this),
                        parentSubCalendarId = subCalendarEntry.data("subCalendarId"),
                        childSubCalendarEntries = $(".child-subcalendar", subCalendarEntry),
                        subCalendarObject = CalendarPlugin.getSubCalendar(calendarDiv, parentSubCalendarId),
                        childSubCalendarIds = $.map(childSubCalendarEntries, function(childSubCalendarEntryElem) {
                            return $(childSubCalendarEntryElem).data("subCalendarId");
                        });

                    if ($.inArray(parentSubCalendarId, subCalendarIds) !== -1) {

                        var checkSubCalendarIsEnable = function(subCalendarId) {
                            for(var i = 0; i < childSubCalendarEntries.length; i++) {
                                if($(childSubCalendarEntries[i]).data("sub-calendar-id") === subCalendarId) {
                                    return !$(childSubCalendarEntries[i]).hasClass("subcalendar-disabled");
                                }
                            }
                            return false;
                        };

                        if (Confluence.TeamCalendars.isSubscriptionSubCalendar(subCalendarObject)) {
                            cache.removeCalendar(parentSubCalendarId);
                            CalendarPlugin.removeSubCalendarEventSource(calendarDiv, parentSubCalendarId);
                            CalendarPlugin.addSubCalendarEventSource(calendarDiv, parentSubCalendarId);
                        }

                        CalendarPlugin.removeSubCalendarEventSource(calendarDiv, $.map(
                            childSubCalendarIds,
                            function(childSubCalendarId) {
                                cache.removeCalendar(childSubCalendarId);
                                return childSubCalendarId;
                            }
                        ));

                        if(subCalendarObject.childSubCalendars !== undefined) {
                            var childSubCalendarIdsInObject = $.map(subCalendarObject.childSubCalendars, function(childSubCalendar) {
                                if(checkSubCalendarIsEnable(childSubCalendar.id) || !childSubCalendar.eventsHidden) {
                                    return childSubCalendar.id;
                                }
                            });
                            CalendarPlugin.addSubCalendarEventSource(calendarDiv, childSubCalendarIdsInObject);
                        }
                    }    else {
                        // Reload a particular child sub-calendar
                        var childSubCalendarIdsToEnable = [];

                        childSubCalendarEntries.filter(function() {
                            return $.inArray($(this).data("subCalendarId"), subCalendarIds) !== -1;
                        }).each(function() {
                            var childSubCalendarEntry = $(this),
                                childSubCalendarId = childSubCalendarEntry.data("subCalendarId");

                            cache.removeCalendar(childSubCalendarId);
                            if (childSubCalendarEntry.hasClass("subcalendar-disabled")) {
                                childSubCalendarEntry.removeClass("subcalendar-disabled");
                            } else {
                                CalendarPlugin.removeSubCalendarEventSource(calendarDiv, childSubCalendarId);
                            }

                            CalendarPlugin.addSubCalendarEventSource(calendarDiv, childSubCalendarId);
                            childSubCalendarIdsToEnable.push(childSubCalendarId);
                        });

                        if (childSubCalendarIdsToEnable.length) {
                            var subCalendarIdsToEnable = childSubCalendarIdsToEnable;
                            var subCalendar = CalendarPlugin.getSubCalendar(calendarDiv, parentSubCalendarId);
                            if (!CalUtil.isDummySubscriptionParentSubCalendar(subCalendar)) {
                                subCalendarIdsToEnable.push(subCalendar.id);
                            }
                            CalendarPlugin.setSubCalendarEventsHidden(calendarDiv, subCalendarIdsToEnable, false, subCalendarEntry);
                        }
                    }
                });
            },

            makeAutoCompleteSearch : function(calendarDiv, searchField, searchOptions, suggestionsContainer, suggestionClickHandler, resultFilter) {
                AutoCompleteSearchHelper.makeAutoCompleteSearch(calendarDiv, searchField, searchOptions, suggestionsContainer, suggestionClickHandler, resultFilter);
            },

            isProcessingEvent : function(calendarDiv) {
                return calendarDiv.data("processingEvent");
            },

            setProcessingEvent : function(calendarDiv, processing, eventForm) {
                if (eventForm) {
                    if (processing) {
                        if (eventForm.disableOkButton) {
                            eventForm.disableOkButton();
                        }
                    } else {
                        if (eventForm.enableOkButton) {
                            eventForm.enableOkButton();
                        }
                    }
                }
                calendarDiv.data("processingEvent", processing);
            },

            showAjaxError : function(container, XMLHttpRequest, textStatus, errorThrown, errorClass, subCalendar) {
                // http://stackoverflow.com/questions/699941/handle-ajax-error-when-a-user-clicks-refresh
                if (!CalendarPlugin.isPageUnloading) {
                    Confluence.TeamCalendars.showAjaxError(container, XMLHttpRequest, textStatus, errorThrown, errorClass, subCalendar);
                }
            },

            showHTMLGenericError: function(container, messageResponse, errorClass) {
                if (!CalendarPlugin.isPageUnloading) {
                    Confluence.TeamCalendars.showHTMLGenericError(container, messageResponse, errorClass);
                }
            },

            showRestrictedCalendarsWarning : function(calendarDiv) {
                $(".restricted-calendars-warning", calendarDiv).removeClass("hidden");
            },

            deleteEvent : function(calendarDiv, params, errorCallback, successCallback) {
                ManageEvent(CalendarPlugin, cache).deleteEvent(calendarDiv, params, errorCallback, successCallback);
            },

            getCalendarServiceBaseUrl : function(calendarDiv, relativePath) {
                return Confluence.TeamCalendars.getCalendarServiceBaseUrl(relativePath);
            },

            getSubCalendars : function(calendarDiv, filterFunction) {
                var subCalendars = calendarDiv.data("subCalendars") || [];
                if (filterFunction) {
                    var filteredSubCalendars = [];
                    $.each(subCalendars, function(index, aSubCalendar) {
                        if (filterFunction(aSubCalendar)) {
                            filteredSubCalendars.push(aSubCalendar);
                        }
                    });

                    return filteredSubCalendars;
                }

                return subCalendars;
            },

            isSubCalendarDeletable : function(calendarDiv, aSubCalendar) {
                return this.isCalendarInEditMode(calendarDiv) && aSubCalendar.deletable;
            },

            isSubCalendarAdministratable : function(calendarDiv, aSubCalendar) {
                return this.isCalendarInEditMode(calendarDiv) && aSubCalendar.administrable;
            },

            isSubCalendarEventsUpdatable : function(calendarDiv, aSubCalendar) {
                return this.isCalendarInEditMode(calendarDiv) && aSubCalendar.eventsEditable;
            },

            canAddEventsToSubcalendar : function(calendarDiv, aSubCalendar) {
                return this.isSubCalendarEventsUpdatable(calendarDiv, aSubCalendar) && !Confluence.TeamCalendars.isJiraSubCalendar(aSubCalendar);
            },

            doesSubCalendarHaveRestrictions : function(subCalendar) {
                return subCalendar.usersPermittedToView.length ||
                    subCalendar.groupsPermittedToView.length ||
                    subCalendar.usersPermittedToEdit.length ||
                    subCalendar.groupsPermittedToEdit.length;
            },

            getSubCalendarsWhichCanAddEvents : function(calendarDiv) {
                return this.getSubCalendars(calendarDiv, function(aSubCalendar) {
                    return CalendarPlugin.canAddEventsToSubcalendar(calendarDiv, aSubCalendar);
                });
            },

            /**
             * This method only get parent calendar by using parent calendar id or child sub calendar id
             * @param calendarDiv
             * @param subCalendarIdOrChildrenCalendarId
             * @returns {*}
             */
            getParentSubCalendar : function(calendarDiv, subCalendarIdOrChildrenCalendarId) {
                var theSubCalendar = null;

                $.each(this.getSubCalendars(calendarDiv), function(subCalendarIdx, subCalendar) {
                    if (subCalendar.id === subCalendarIdOrChildrenCalendarId) {
                        theSubCalendar = subCalendar;
                        return false;
                    } else {
                        var theChildSubCalendar = $.grep(subCalendar.childSubCalendars || [], function(childSubCalendar) {
                            return childSubCalendar.id == subCalendarIdOrChildrenCalendarId;
                        });

                        if ((theSubCalendar = theChildSubCalendar && theChildSubCalendar.length ? subCalendar : null))
                            return false; // Stop iterating
                    }
                });

                return theSubCalendar;
            },

            getSubCalendar : function(calendarDiv, subCalendarId) {
                var theSubCalendar = null;

                $.each(this.getSubCalendars(calendarDiv), function(subCalendarIdx, subCalendar) {
                    if (subCalendar.id === subCalendarId) {
                        theSubCalendar = subCalendar;
                        return false;
                    } else {
                        theSubCalendar = $.grep(subCalendar.childSubCalendars || [], function(childSubCalendar) {
                            return childSubCalendar.id == subCalendarId;
                        });

                        if ((theSubCalendar = theSubCalendar && theSubCalendar.length ? theSubCalendar[0] : null))
                            return false; // Stop iterating
                    }
                });

                return theSubCalendar;
            },

            getSanboxEventTypeRemindersFromSubCalendar: function(calendarDiv, subCalendarId) {
                var theSubCalendar =  this.getSubCalendar(calendarDiv, subCalendarId);
                if(theSubCalendar) {
                    return theSubCalendar.sanboxEventTypeReminders;
                }
            },

            getCurrentReminderForEventType: function(calendarDiv, eventEditDialog) {
                var eventTypeReminder = null;
                var subCalendarIdSelected = eventEditDialog.getSelectedSubCalendarId();
                var eventTypeSelected = eventEditDialog.getSelectedEventType();

                if (CalUtil.isCustomEventType(eventTypeSelected)) {
                    var customEventTypes = this.getCustomEventTypeFromSubCalendar(calendarDiv, subCalendarIdSelected);
                    if(customEventTypes) {
                        $.each(customEventTypes, function(idx, customEventTypeItem) {
                            if(customEventTypeItem.customEventTypeId === eventTypeSelected && customEventTypeItem.periodInMins > 0) {
                                eventTypeReminder = customEventTypeItem;
                                return false;
                            }
                        });
                    }
                } else {
                    var eventTypeReminders = this.getSanboxEventTypeRemindersFromSubCalendar(calendarDiv, subCalendarIdSelected);
                    if(eventTypeReminders) {
                        $.each(eventTypeReminders, function(idx, eventTypeReminderItem) {
                            if(eventTypeReminderItem.eventTypeId === eventTypeSelected || eventTypeReminderItem.eventTypeId === eventTypeSelected + "-calendar") {
                                eventTypeReminder = eventTypeReminderItem;
                                return false;
                            }
                        });
                    }
                }

                return eventTypeReminder;
            },

            getCustomEventTypeFromSubCalendar: function(calendarDiv, subCalendarId) {
                var theSubCalendar =  this.getSubCalendar(calendarDiv, subCalendarId);
                if(theSubCalendar) {
                    return theSubCalendar.customEventTypes;
                }
            },

            setSubCalendar: function(subCalendarId, calendarDiv, payload) {
                var subCalendars = calendarDiv.data("subCalendars");
                for(var i = 0; i < subCalendars.length; i++) {
                    if(subCalendars[i].id === subCalendarId) {
                        subCalendars[i] = $.isArray(payload) ? payload[0] : payload;
                    }
                }
                calendarDiv.data("subCalendars", subCalendars);
            },

            setSubCalendars : function(calendarDiv, subCalendars) {
                // filter restricted calendars in space view
                if(CalUtil.isSpaceCalendarView(calendarDiv)) {
                    subCalendars = _.filter(subCalendars, function(subcalendar){
                        return subcalendar.eventsViewable || CalUtil.isDummySubscriptionParentSubCalendar(subcalendar);
                    });
                }
                calendarDiv.data("subCalendars", $.isArray(subCalendars) ? subCalendars : (subCalendars ? [ subCalendars ] : null));
            },

            showSubCalendarEdit: function(calendarDiv, subCalendar) {
                var subCalendarEditDialog;
                //Jira is a special case. We show it in the edit event dialog.
                if (Confluence.TeamCalendars.isJiraSubCalendar(subCalendar)){
                    var isInternalSubscribe = Confluence.TeamCalendars.isInternalSubscriptionSubCalendar(subCalendar);

                    subCalendarEditDialog = Confluence.TeamCalendars.Dialogs.getEditEventDialog(
                        {   //Dummy event since we are abusing the edit event dialog
                            "title" : isInternalSubscribe ? subCalendar.sourceSubCalendar.name : subCalendar.name,
                            "eventType" : (isInternalSubscribe ? subCalendar.sourceSubCalendar.type : subCalendar.type) + "-calendar", //Add "-calendar" to the name so we know this is for editing a calendar, and not one of it's events.
                            "subCalendarId" : subCalendar.id
                            //"subCalendarId" : isInternalSubscribe ? subCalendar.sourceSubCalendar.id : subCalendar.id
                        },
                        subCalendar,
                        CalendarPlugin,
                        calendarDiv).show();
                } else {
                    var editDialogView = Confluence.TeamCalendars.Dialogs.getSubCalendarEditDialog(
                        subCalendar,
                        CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv),
                        calendarDiv,
                        CalendarPlugin,
                        cache);

                    subCalendarEditDialog = editDialogView.render();

                    // show error message
                    var dialogContent = subCalendarEditDialog.getCurrentPanel().body;

                    Confluence.TeamCalendars.setFieldErrors(dialogContent, null);

                    subCalendarEditDialog.show();
                    //always show edit subcalendar dialog when edit
                    subCalendarEditDialog.gotoPanel(CalUtil.panelEditCalendar.GENERAL_PANEL);
                    $("input[name='name']", dialogContent).focus();

                    // HACK : don't know how to pass the view out hic
                    subCalendarEditDialog.belongedView = editDialogView;

                    // if Tour is running then go to add custom event type dialog
                    if (CalendarTour.isShowCustomEventTypeFrom(subCalendar.id)) {
                        editDialogView.showAddEventTypeForm();
                    }

                    //disable panel button edit/custom event type if don't have permission
                    if(!this.isSubCalendarAdministratable(calendarDiv, subCalendar)) {
                        $(subCalendarEditDialog.getPanel(CalUtil.panelEditCalendar.GENERAL_PANEL).button).addClass("hidden"); //disable general panel
                        $(subCalendarEditDialog.getPanel(CalUtil.panelEditCalendar.EVENT_TYPE_PANEL).button).addClass("hidden"); //disable custom event type
                        $(subCalendarEditDialog.getPanel(CalUtil.panelEditCalendar.RESTRICTION_PANEL).button).addClass("hidden"); //disable restriction
                    }

                    //process behaviour when event type panel active
                    subCalendarEditDialog.getCurrentPanel().onselect = function() {
                        $("#edit-calendar-dialog").find(".button-panel-button.submit").removeClass("hidden");
                    };
                }
                return subCalendarEditDialog;
            },
            showCustomEventEditForm : function (calendarDiv, subCalendar, eventTypeId, editEventDialog) {
                var subCalendarEditDialog = this.showSubCalendarEdit(calendarDiv, subCalendar);

                if ( !(!Confluence.TeamCalendars.isInternalSubscriptionSubCalendar(subCalendar) && Confluence.TeamCalendars.isJiraSubCalendar(subCalendar))) {
                    var editDialogView = subCalendarEditDialog.belongedView;
                    if(eventTypeId) {
                        // edit existed custom event
                        eventTypeId = Confluence.TeamCalendars.isJiraType(eventTypeId) ? eventTypeId + "-calendar" : eventTypeId;
                        editDialogView.selectCustomEvent(eventTypeId);
                    } else {
                        // add new custom event
                        editDialogView.showAddEventTypeForm();
                    }
                }
                subCalendarEditDialog.gotoPanel(CalUtil.panelEditCalendar.EVENT_TYPE_PANEL);
                return subCalendarEditDialog;
            },
            updateCustomEventType: function(calendarDiv, subCalendarId, customEventTypeData) {
                var dataSubcalendars = this.getSubCalendars(calendarDiv);

                for (var i = 0; i < dataSubcalendars.length; i++) {
                    if(dataSubcalendars[i].id === subCalendarId) {
                        var existCustomEventType = false;
                        for(var j = 0; j < dataSubcalendars[i].customEventTypes.length; j++) {
                            if(dataSubcalendars[i].customEventTypes[j].customEventTypeId === customEventTypeData.customEventTypeData) {
                                dataSubcalendars[i].customEventTypes[j] = customEventTypeData;
                                existCustomEventType = true;
                                break;
                            }
                        }
                        if(!existCustomEventType) {
                            dataSubcalendars[i].customEventTypes.push(customEventTypeData);
                        }
                        break;
                    }
                }

                calendarDiv.data("subCalendars", dataSubcalendars);
            },

            refreshCachedSubCalendars : function(calendarDiv, successCallback, errorCallback) {
                var requestData = { }; // Empty

                if (CalendarPlugin.getParameter(calendarDiv, "include")) {
                    requestData.include = CalendarPlugin.getParameter(calendarDiv, "include");
                }

                CalUtil.putCalendarContextParams(requestData);

                $.ajax({
                    cache : false,
                    converters : {
                        "text json" : function(jsonObject) {
                            return jsonObject;
                        }
                    },
                    data : requestData,
                    dataFilter : function(data) {
                        var subCalendarsResponseEntity = $.parseJSON(data);
                        if (subCalendarsResponseEntity.success)
                            CalendarPlugin.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                        return subCalendarsResponseEntity;
                    },
                    dataType : "json",
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST);
                        if (errorCallback)
                            errorCallback(XMLHttpRequest, textStatus, errorThrown);
                    },
                    success : function(responseEntity) {
                        if (responseEntity.success) {
                            CalendarPlugin.setSubCalendars(calendarDiv, responseEntity.payload);
                            if (successCallback)
                                successCallback(responseEntity.payload);
                            CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST);
                        } else {
                            CalendarPlugin.setGenericErrors(calendarDiv, AJS.I18n.getText("calendar3.error.unknown"), CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST);
                        }
                    },
                    type: "GET",
                    timeout: CalendarPlugin.ajaxTimeout,
                    url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/subcalendars.json")
                });
            },

            mergeSubCalendarObjectsToArray : function(arrayWithSubCalendarObject) {
                return Confluence.TeamCalendars.mergeSubCalendarObjectsToArray(arrayWithSubCalendarObject);
            },

            setGenericErrors : function(container, message, errorClass) {
                Confluence.TeamCalendars.setGenericErrors(container, message, errorClass);
            },

            shouldShowFeatureDiscoveryDialog : function(calendarDiv, subCalendarId) {
                // fixed ticket TEAMCAL-1797
                return CalendarPlugin.getParameter(calendarDiv, "showCalendarDiscoveryDialog") === "true";
            },

            setSubCalendarEventsHidden : function(calendarDiv, subCalendarId, hidden, theEntry) {
                subCalendarId = $.isArray(subCalendarId) ? subCalendarId : subCalendarId;

                return $.ajax({
                    cache: false,
                    data: {
                        subCalendarId: subCalendarId
                    },
                    dataType: "json",
                    type: hidden ? "PUT" : "DELETE",
                    error: function(jqXHR, textStatus, errorThrown) {
                        $.each(subCalendarId, function(subCalendarIdIdx, _subCalendarId) {
                            CalendarPlugin.showAjaxError(
                                calendarDiv, jqXHR, textStatus, errorThrown,
                                CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_TOGGLE_EVENTS + CalendarPlugin.getStringAsHex(_subCalendarId)
                            );
                        });
                    },
                    success: function() {
                        $.each(subCalendarId, function(subCalendarIdIdx, _subCalendarId) {
                            //set status event when hidden
                            CalendarPlugin.getSubCalendar(calendarDiv, _subCalendarId).eventsHidden = hidden;
                            CalendarPlugin.checkCalendarHasAllChildDisable(theEntry);
                            CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_TOGGLE_EVENTS + CalendarPlugin.getStringAsHex(_subCalendarId));
                        });
                    },
                    timeout: CalendarPlugin.ajaxTimeout,
                    url: CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/preferences/events/hidden.json")
                });
            },

            checkCalendarHasAllChildDisable : function(subCalendarChecked) {
                $(subCalendarChecked).filter(function(){
                    var childs = $('li.child-subcalendar', subCalendarChecked);
                    var childEnables = $('li.child-subcalendar:not(.subcalendar-disabled)', subCalendarChecked);
                    if(childs.length !== 0 && childEnables.length === 0) {
                        subCalendarChecked.addClass("allchildsubcalendar-disabled").addClass("subcalendar-disabled");
                    } else {
                        subCalendarChecked.removeClass("allchildsubcalendar-disabled").removeClass("subcalendar-disabled");
                    }
                });
            },

            updateAvailableSubCalendarsInSubCalendarPanel : function(calendarDiv) {
                SubCalendarPanel(CalendarPlugin, calendarDiv, cache).updateAvailableSubCalendarsInSubCalendarPanel();
            },

            unsubscribeFromSubcalendar : function(calendarDiv, subCalendar) {
                if (!CalendarPlugin.isProcessingSubCalendar(calendarDiv)) {
                    CalendarPlugin.setProcessingSubCalendar(calendarDiv, true);
                    var spinnerDefer = CalendarPlugin.setSubCalendarSpinnerIconVisible(calendarDiv, true);
                    var resolveSpinner = function(){
                        if (spinnerDefer) spinnerDefer.resolve();
                    };

                    if (subCalendar.subscriptionId) {
                        CalendarPlugin._deleteSubCalendarInternal(calendarDiv, subCalendar.id,
                            function(XMLHttpRequest, textStatus, errorThrown) {
                                CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                                resolveSpinner();
                                CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                            },
                            function(responseEntity) {
                                if (responseEntity.success) {
                                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);

                                    // Clear all errors related to loading events of a sub-calendar (and its children).
                                    $.each($.merge([ subCalendar ], subCalendar.childSubCalendars || []), function(subCalendarIdx, subCalendar) {
                                        CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS + CalendarPlugin.getStringAsHex(subCalendar.id));
                                    });

                                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendar.id);
                                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendar.childSubCalendars);
                                    CalendarPlugin.setSubCalendars(calendarDiv, responseEntity.payload);
                                    CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                                } else {
                                    CalendarPlugin.setGenericErrors(calendarDiv, AJS.I18n.getText("calendar3.error.unknown"), CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                                }

                                resolveSpinner();
                                CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                            });
                    } else {
                        $.ajax({
                            cache: false,
                            converters : {
                                "text json" : function(jsonObject) {
                                    return jsonObject;
                                }
                            },
                            data: (function() {
                                var ajaxData = { subCalendarId : subCalendar.id };
                                if (CalendarPlugin.getParameter(calendarDiv, "include"))
                                    ajaxData.include = CalendarPlugin.getParameter(calendarDiv, "include");

                                CalUtil.putCalendarContextParams(ajaxData);

                                return ajaxData;
                            })(),
                            dataType: "json",
                            dataFilter : function(data) {
                                var subCalendarsResponseEntity = $.parseJSON(data);
                                if (subCalendarsResponseEntity.success)
                                    CalendarPlugin.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                                return subCalendarsResponseEntity;
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                CalendarPlugin.showAjaxError(calendarDiv, jqXHR, textStatus, errorThrown);
                                CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                            },
                            success : function(responseEntity) {
                                // when delete/remove calendar in single view => redirect to current space calendars
                                if(CalUtil.isSingleCalendarView(calendarDiv)) {
                                    window.location.href = AJS.contextPath() + "/display/" + encodeURIComponent(AJS.Meta.get("space-key")) + "/calendars";
                                } else {
                                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);
                                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendar.id);
                                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendar.childSubCalendars);
                                    CalendarPlugin.setSubCalendars(calendarDiv, responseEntity.payload);
                                    CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                                    CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                                }
                                AJS.trigger("calendar.removed");
                            },
                            complete: function(){
                                resolveSpinner();
                            },
                            type : "DELETE",
                            timeout : CalendarPlugin.ajaxTimeout,
                            url : CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/preferences/subcalendars.json")
                        });
                    }

                }
            },

            getNextUnusedSubCalendarColor : function(calendarDiv) {
                var subCalendars = CalendarPlugin.getSubCalendars(calendarDiv);
                var subCalendarColorClasses = CalendarPlugin.getParameter(calendarDiv, "subCalendarColorClass");
                for (var colorClassIndex = 0; colorClassIndex < subCalendarColorClasses.length; ++colorClassIndex) {
                    var colorClass = subCalendarColorClasses[colorClassIndex];
                    var colorClassUsed = false;

                    for (var subCalendarIndex = 0; subCalendarIndex < subCalendars.length; ++subCalendarIndex) {
                        if (colorClass === subCalendars[subCalendarIndex].color) {
                            colorClassUsed = true;
                            break;
                        }
                    }

                    if (!colorClassUsed)
                        return colorClass;
                }

                return subCalendars.length ? subCalendarColorClasses[subCalendars.length % subCalendarColorClasses.length] : "subcalendar-blue";
            },

            setProcessingSubCalendar : function(calendarDiv, processing) {
                calendarDiv.data("processingSubCalendar", processing);
            },

            isProcessingSubCalendar : function(calendarDiv) {
                return calendarDiv.data("processingSubCalendar");
            },

            getDeleteSubCalendarConfirmationDialog : function(calendarDiv, subCalendar, subscriberCount) {
                var deleteSubCalendarConfirmationDialog = this.createDeleteSubCalendarConfirmationDialog(calendarDiv, subCalendar, subscriberCount);
                $("input[name='subCalendarId']", deleteSubCalendarConfirmationDialog.getCurrentPanel().body).val(subCalendar.id);
                return deleteSubCalendarConfirmationDialog;
            },

            createDeleteSubCalendarConfirmationDialog : function(calendarDiv, subCalendar, subscriberCount) {
                var deleteConfirmationDialog = new AJS.Dialog({
                    height : 290,
                    width : 550,
                    id : "delete-calendar-dialog"
                });

                deleteConfirmationDialog.addHeader(Confluence.TeamCalendars.isJiraSubCalendar(subCalendar) ? AJS.I18n.getText("calendar3.heading.confirmdeleteevent") : AJS.I18n.getText("calendar3.heading.confirmdeletesubcalendar"));
                deleteConfirmationDialog.addPanel(
                    AJS.I18n.getText("calendar3.heading.confirmdeletesubcalendar"),
                    Confluence.TeamCalendars.Templates.confirmRemoveSubCalendar({
                        "subCalendar" : subCalendar,
                        "subscriberCount" : subscriberCount
                    }),
                    "delete-subcalendar-confirmation-panel");

                var dialogContent = deleteConfirmationDialog.getCurrentPanel().body;

                $("form.sub-calendar-delete-confirm", dialogContent).submit(function() {
                    return false;
                });

                var spinnerDefer = CalendarPlugin.setSubCalendarSpinnerIconVisible(calendarDiv, true);
                deleteConfirmationDialog.addButton(Confluence.TeamCalendars.isJiraSubCalendar(subCalendar) ? AJS.I18n.getText("calendar3.button.confirmdeleteevent") : AJS.I18n.getText("calendar3.deletecalendarbutton"), function() {
                    if (!CalendarPlugin.isProcessingSubCalendar(calendarDiv)) {
                        CalendarPlugin.setProcessingSubCalendar(calendarDiv, true);

                        var subCalendarToDelete = CalendarPlugin.getSubCalendar(calendarDiv, $("input[name='subCalendarId']", dialogContent).val());
                        CalendarPlugin._deleteSubCalendarInternal(calendarDiv, subCalendarToDelete.subscriptionId || subCalendarToDelete.id,
                            function(XMLHttpRequest, textStatus, errorThrown) {
                                CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                                deleteConfirmationDialog.remove();
                                spinnerDefer.resolve();
                                CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                            },
                            function(responseEntity) {
                                if (responseEntity.success) {
                                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);

                                    // Clear all errors related to loading events of a sub-calendar (and its children).
                                    $.each($.merge([ subCalendarToDelete ], subCalendarToDelete.childSubCalendars || []), function(subCalendarIdx, subCalendar) {
                                        CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS + CalendarPlugin.getStringAsHex(subCalendar.id));
                                    });

                                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendarToDelete.id);
                                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendarToDelete.childSubCalendars);
                                    CalendarPlugin.setSubCalendars(calendarDiv, responseEntity.payload);
                                    CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                                } else {
                                    CalendarPlugin.setGenericErrors(calendarDiv, AJS.I18n.getText("calendar3.error.unknown"), CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                                }

                                deleteConfirmationDialog.remove();
                                spinnerDefer.resolve();
                                CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                            });
                    }

                    return false;
                });

                deleteConfirmationDialog.addLink(AJS.I18n.getText("cancel.name"), function() {
                    deleteConfirmationDialog.remove();
                    spinnerDefer.resolve();
                    return false;
                });

                return deleteConfirmationDialog;
            },
            deleteSubCalendar : function(calendarDiv, subCalendar) {
                if (!CalendarPlugin.isProcessingSubCalendar(calendarDiv)) {
                    CalendarPlugin.setProcessingSubCalendar(calendarDiv, true);
                    var spinnerDefer = CalendarPlugin.setSubCalendarSpinnerIconVisible(calendarDiv, true);
                    var data = {subCalendarId: subCalendar.subscriptionId || subCalendar.id};
                    CalUtil.putCalendarContextParams(data);

                    $.ajax({
                        cache : false,
                        data : data,

                        dataType : "json",
                        error : function(XMLHttpRequest, textStatus, errorThrown) {
                            CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_DELETE);
                            CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                        },
                        success : function(responseEntity) {
                            var subCalendarEditDialog = calendarDiv.data("subCalendarEditFormDialog");

                            if (subCalendarEditDialog)
                                subCalendarEditDialog.hide();

                            var deleteSubCalendarConfirmationDialog = CalendarPlugin.getDeleteSubCalendarConfirmationDialog(calendarDiv, subCalendar, responseEntity.subscriptionCount),
                                dialogContent = deleteSubCalendarConfirmationDialog.getCurrentPanel().body,
                                calendarToDeleteSpan = $(".calendar-to-delete", dialogContent);

                            //If we do not remove this attribute ThreeDots will revert to the old text when we try to
                            //call ThreeDots() or update()
                            calendarToDeleteSpan.removeAttr("ThreeDots").empty().append(
                                $(document.createElement("span")).addClass("ellipsis_text").text(subCalendar.name));

                            CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);

                            var escapeKeyListener = function(jsEvent) {
                                if (27 === jsEvent.keyCode) {
                                    CalendarPlugin.setProcessingSubCalendar(calendarDiv, false);
                                    spinnerDefer.resolve();
                                    $(document).unbind("keypress", escapeKeyListener);
                                }
                            };
                            $(document).keypress(escapeKeyListener);

                            deleteSubCalendarConfirmationDialog.show();
                            calendarToDeleteSpan.ThreeDots();
                        },
                        complete: function(){
                            if (spinnerDefer) spinnerDefer.resolve();
                        },
                        type : "GET",
                        timeout : CalendarPlugin.ajaxTimeout,
                        url : CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/subcalendars/links.json")
                    });
                }
            },

            _deleteSubCalendarInternal : function(calendarDiv, subCalendarId, errorCallback, successCallback) {
                var requestData = {
                    subCalendarId : subCalendarId
                };

                if (CalendarPlugin.getParameter(calendarDiv, "include"))
                    requestData.include = CalendarPlugin.getParameter(calendarDiv, "include");

                CalUtil.putCalendarContextParams(requestData);

                $.ajax({
                    cache : false,
                    converters : {
                        "text json" : function(jsonObject) {
                            return jsonObject;
                        }
                    },
                    data : requestData,
                    dataFilter: function(data) {
                        var subCalendarsResponseEntity = $.parseJSON(data);
                        if (subCalendarsResponseEntity.success) {
                            CalendarPlugin.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                        }

                        return subCalendarsResponseEntity;
                    },
                    dataType : "json",
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        if (errorCallback)
                            errorCallback(XMLHttpRequest, textStatus, errorThrown);
                    },
                    success : function(responseEntity) {
                        // when delete/remove calendar in single view => redirect to current space calendars
                        if(CalUtil.isSingleCalendarView(calendarDiv)) {
                            window.location.href = AJS.contextPath() + "/display/" + encodeURIComponent(AJS.Meta.get("space-key")) + "/calendars";
                        } else {
                            if (successCallback)
                                successCallback(responseEntity);
                        }

                        AJS.trigger("calendar.removed");
                    },
                    type : "DELETE",
                    timeout : CalendarPlugin.ajaxTimeout,
                    url : CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/subcalendars.json")
                });
            },

            addSubCalendarEventSource : function(calendarDiv, subCalendarId) {
                if (!subCalendarId)
                    return;

                var subCalendarIds = Confluence.TeamCalendars.getAsArray(subCalendarId),
                    visibleEventSources = calendarDiv.data("visibleEventSources") || {};

                $.each(subCalendarIds, function(idIdx, aSubCalendarId) {
                    if (!visibleEventSources[aSubCalendarId]) {
                        visibleEventSources[aSubCalendarId] = CalendarPlugin.getSubCalendarEventSource(calendarDiv, aSubCalendarId);
                        CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("addEventSource", visibleEventSources[aSubCalendarId]);
                    }
                });

                calendarDiv.data("visibleEventSources", visibleEventSources);
            },

            removeSubCalendarEventSource : function(calendarDiv, subCalendarId) {
                if (!subCalendarId)
                    return;

                var subCalendarIds = Confluence.TeamCalendars.getAsArray(subCalendarId),
                    visibleEventSources = calendarDiv.data("visibleEventSources") || {};

                $.each(subCalendarIds, function(idIdx, aSubCalendarId) {
                    if (visibleEventSources[aSubCalendarId]) {
                        CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("removeEventSource", visibleEventSources[aSubCalendarId]);
                        visibleEventSources[aSubCalendarId] = null;
                    }
                });

                calendarDiv.data("visibleEventSources", visibleEventSources);
            },

            isHttpsServer : function(calendarDiv) {
                return CalendarPlugin.getParameter(calendarDiv, "baseUrl").substring(5,0).toLowerCase() != "https";
            },

            getSubCalendarEventSource : function(calendarDiv, subCalendarId) {
                var eventSources = calendarDiv.data("eventSources") || {},

                    getSubCalendarEventsRetrieveQueue = function(_calendarDiv, _subCalendarId) {
                        var retrieveEventsQueue = _calendarDiv.data("retrieveEventsQueue") || {};
                        if (!retrieveEventsQueue[_subCalendarId])
                            retrieveEventsQueue[_subCalendarId] = [];

                        _calendarDiv.data("retrieveEventsQueue", retrieveEventsQueue);

                        return retrieveEventsQueue[_subCalendarId];
                    },

                    eventSource = eventSources[subCalendarId] || function(startDate, endDate, reportEventsAndPopCallback) {
                            // Sometimes FullCalendar passes in invalid dates?!
                            if (!(isNaN(startDate.getTime()) || isNaN(endDate.getTime()))) {
                                //Check if the data is in the cache
                                if (cache.hasCalendar(subCalendarId)
                                    && cache.getCalendarStart(subCalendarId).getTime() < startDate.getTime()
                                    && cache.getCalendarEnd(subCalendarId).getTime() > endDate.getTime()) {
                                    reportEventsAndPopCallback(cache.getCalendarData(subCalendarId));
                                    return;
                                }

                                var subCalendarEventsRetrieveQueue = getSubCalendarEventsRetrieveQueue(calendarDiv, subCalendarId);
                                for (var getEventsRequestIndex = 0; getEventsRequestIndex < subCalendarEventsRetrieveQueue.length; ++getEventsRequestIndex) {
                                    var aRequest = subCalendarEventsRetrieveQueue.shift();
                                    if (!aRequest.aborted && aRequest.xhr.readyState !== 4) {
                                        try
                                        {
                                            aRequest.xhr.abort();
                                        }
                                        catch (err) {
                                            // Most likely because of http://dev.jquery.com/ticket/6498
                                        }
                                        aRequest.xhr.aborted = true;
                                    }
                                }

                                var startDateWithOffset = new Date(startDate.getTime() - (1000 * 60 * 60 * 24 * 30)),
                                    endDateWithOffset = new Date(endDate.getTime() + (1000 * 60 * 60 * 24 * 30)),

                                    ajaxData = {
                                        subCalendarId: subCalendarId,
                                        userTimeZoneId: Confluence.TeamCalendars.getUserTimeZone(),
                                        start: $.fullCalendar.formatDate(startDateWithOffset, "u"),
                                        end : $.fullCalendar.formatDate(endDateWithOffset, "u")
                                    },

                                    parentSubCalendar = CalendarPlugin.getSubCalendars(calendarDiv, function(aSubCalendar) {
                                        if (!aSubCalendar.childSubCalendar)
                                            return false;

                                        var foundParent = false;
                                        $.each(aSubCalendar.childSubCalendar, function(childIdx, childSubCalendar) {
                                            if (childSubCalendar.id === subCalendarId) {
                                                foundParent = true;
                                                return false; // Stop iterating
                                            }
                                        });

                                        return foundParent;
                                    });

                                if (parentSubCalendar.length)
                                    ajaxData.parentSubCalendarId = parentSubCalendar[0].id;


                                var xhr = $.ajax({
                                    cache : false,
                                    data : ajaxData,
                                    dataType : "json",
                                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                                        if (Confluence.TeamCalendars.isRequireOauth(XMLHttpRequest)) {
                                            var responseEntity = $.parseJSON(XMLHttpRequest.responseText),
                                                jiraOauthErrorsContainer = $(".jira-calendars-oauth-warnings", calendarDiv),
                                                oAuthUrl = responseEntity.oAuthUrl,
                                                oAuthApproveMessageContainer = $("div", jiraOauthErrorsContainer).filter(function() {
                                                    return oAuthUrl === $(this).data("oAuthUrl");
                                                }),

                                                createNewOAuthDanceMessage = function() {
                                                    jiraOauthErrorsContainer.append(
                                                        Confluence.TeamCalendars.Templates.requireOauthMessage({
                                                            "oAuthUrl" : oAuthUrl,
                                                            "subCalendarIdsArrayJson" : JSON.stringify([ subCalendarId ]),
                                                            "subCalendarNamesArrayJson" : JSON.stringify([ responseEntity.subCalendarName ]),
                                                            "subCalendarName" : $("<div/>", { text : responseEntity.subCalendarName }).html()
                                                        })
                                                    ).find(".approve-dance").click(function() {
                                                        AppLinks.authenticateRemoteCredentials(
                                                            responseEntity.oAuthUrl,
                                                            function() {
                                                                var theOauthApproveMessageContainer = $("div", jiraOauthErrorsContainer).filter(function() {
                                                                    return oAuthUrl === $(this).data("oAuthUrl");
                                                                });

                                                                CalendarPlugin.reloadSubCalendar(calendarDiv, theOauthApproveMessageContainer.data("subCalendarIds"));
                                                                theOauthApproveMessageContainer.remove();
                                                            },
                                                            function() {
                                                                alert(AJS.I18n.getText("calendar3.oauth.trydancingagain"));
                                                            }
                                                        );

                                                        return false;
                                                    });
                                                },

                                                appendSubCalendarsToOAuthMessage = function() {
                                                    var subCalendarIds = oAuthApproveMessageContainer.data("subCalendarIds");
                                                    if ($.inArray(subCalendarId, subCalendarIds) === -1)
                                                        subCalendarIds.push(subCalendarId);

                                                    var newSubCalendarNames = oAuthApproveMessageContainer.data("subCalendarNames");
                                                    if ($.inArray(responseEntity.subCalendarName, newSubCalendarNames) === -1)
                                                        newSubCalendarNames.push(responseEntity.subCalendarName);

                                                    $("span.subcalendar-names", oAuthApproveMessageContainer.data("subCalendarIds", subCalendarIds).data("subCalendarNames", newSubCalendarNames)).text(newSubCalendarNames.join(", "));
                                                };

                                            if (!oAuthApproveMessageContainer.length) {
                                                createNewOAuthDanceMessage();
                                            } else {
                                                appendSubCalendarsToOAuthMessage();
                                            }

                                        } else if (XMLHttpRequest.status == 403) {
                                            if (CalendarPlugin.getParameter(calendarDiv, "showHiddenSubCalendars") === "true") {
                                                CalendarPlugin.showRestrictedCalendarsWarning(calendarDiv);
                                            } else {
                                                // Do not display "restricted calendar error" in space calendar
                                                // just hide them
                                                if(!CalUtil.isSpaceCalendarView(calendarDiv)) {
                                                    CalendarPlugin.showAjaxError(
                                                        calendarDiv,
                                                        XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS + CalendarPlugin.getStringAsHex(subCalendarId)
                                                    );
                                                }
                                            }

                                        } else if (textStatus !== "abort") {
                                            var subCalendar = CalendarPlugin.getSubCalendar(calendarDiv, subCalendarId);
                                            CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS + CalendarPlugin.getStringAsHex(subCalendarId), subCalendar);
                                            //bind event click in information error
                                            $(calendarDiv).find("#calendar-change-jql").click(function() {
                                                var that = this;
                                                var jiraCalendarId = $(that).parent().data("jiraCalendarId");
                                                if(jiraCalendarId) {
                                                    var jiraSubCalendar = CalendarPlugin.getSubCalendar(calendarDiv, jiraCalendarId);
                                                    if(jiraSubCalendar && jiraSubCalendar.eventsEditable) {
                                                        CalendarPlugin.showSubCalendarEdit(calendarDiv, jiraSubCalendar);
                                                        //process behaviour when event type panel active
                                                        $("#edit-calendar-dialog").find(".button-panel-button.submit").removeClass("hidden");
                                                    }
                                                }
                                            });
                                        }

                                        reportEventsAndPopCallback([]);
                                    },
                                    success : function(response, status) {
                                        var events = response.events;
                                        var truncatedEvents = [];
                                        CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS + CalendarPlugin.getStringAsHex(subCalendarId));
                                        events = $.map(events || [], function(anEvent) {
                                            /* HACK alert: Make GH sprint dates appear as all day events, but preserve some information indiciating it is not
                                             /* when we display the event details in the event details popout */
                                            if (anEvent.className === "greenhopper-sprint" && !anEvent.allDay) {
                                                anEvent.allDay = !anEvent.allDay;
                                                anEvent.allDayFlipped = true;
                                            }

                                            return anEvent;
                                        });

                                        // Under some circumstances of aborting this AJAX call, the status could be success and events null.
                                        if (status === "success" && events) {
                                            truncatedEvents = CalendarPlugin.getEventsTruncated(calendarDiv, events);
                                        }

                                        reportEventsAndPopCallback(truncatedEvents);
                                        cache.addDataToCalendar(subCalendarId, truncatedEvents, startDateWithOffset, endDateWithOffset);

                                        var subCalendar = CalendarPlugin.getSubCalendar(calendarDiv, subCalendarId);
                                        if (subCalendar.warnings && subCalendar.warnings.length)
                                            CalendarPlugin.setGenericErrors(calendarDiv, subCalendar.warnings, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST_EVENTS + CalendarPlugin.getStringAsHex(subCalendarId));

                                        var editSubCalendarId = CalendarPlugin.getParameter(calendarDiv, "editSubCalendarId"), editEventUid = CalendarPlugin.getParameter(calendarDiv, "editEventUid");
                                        if (editSubCalendarId && editEventUid) {
                                            var eventsMatching = CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("clientEvents", function(anEvent) {
                                                return anEvent.subCalendarId === editSubCalendarId && anEvent.id === editEventUid;
                                            });
                                            if (eventsMatching.length) {
                                                CalendarPlugin.setParameter(calendarDiv, "editSubCalendarId" ,"");
                                                CalendarPlugin.setParameter(calendarDiv, "editEventUid" ,"");

                                                $("#calendar-dialog-panel").remove(); // Hide any event edit dialog, just in case.
                                                Confluence.TeamCalendars.Dialogs.getEditEventDialog(eventsMatching[0], subCalendar, CalendarPlugin, calendarDiv).show();
                                            }
                                        }
                                    },
                                    type : "GET",
                                    timeout : CalendarPlugin.ajaxTimeout,
                                    url : CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/events.json")
                                });

                                subCalendarEventsRetrieveQueue.push({ xhr: xhr });
                            }
                        };

                eventSources[subCalendarId] = eventSource;
                calendarDiv.data("eventSources", eventSources);
                return eventSource;
            },

            getEventsTruncated : function(calendarDiv, events, reset) {
                var currentView = this.getCalendarPanel(calendarDiv).fullCalendar("getView");
                var maxEventsToDisplayPerCalendar = parseInt(this.getParameter(calendarDiv, "maxEventsToDisplayPerCalendar"));

                // Group events based on sub-calendar
                var eventsMap = {};
                $.each(events, function(eventIdx, anEvent) {
                    if (!eventsMap[anEvent.subCalendarId])
                        eventsMap[anEvent.subCalendarId] = [];

                    eventsMap[anEvent.subCalendarId].push(anEvent);
                });

                // Function to sort events by date
                var sortEvents = function(_eventsArray) {
                    _eventsArray.sort(function(leftEvent, rightEvent) {
                        var leftDate = leftEvent._start || $.fullCalendar.parseISO8601(leftEvent.start, true);
                        var rightDate = rightEvent._start || $.fullCalendar.parseISO8601(rightEvent.start, true);

                        return leftDate.getTime() - rightDate.getTime();
                    });
                };

                var truncatedSubCalendarNames = [];
                var finalEventsMap = {};
                $.each(eventsMap, function(subCalendarId, eventArray) {
                    sortEvents(eventArray);

                    var visStart = currentView.visStart;
                    var finalEventArray;

                    if (eventArray.length > maxEventsToDisplayPerCalendar) {
                        var idxOfFirstEventInVisStart = -1;
                        $.each(eventArray, function(eventIdx, anEvent) {
                            var startDate = anEvent._start || $.fullCalendar.parseISO8601(anEvent.start, true);
                            if (startDate >= visStart) {
                                idxOfFirstEventInVisStart = eventIdx;
                                return false; // Stop iterating
                            }
                        });

                        if (-1 === idxOfFirstEventInVisStart) {
                            // If no events start within the visualization range, just take the last ones
                            finalEventArray = eventArray.slice(-maxEventsToDisplayPerCalendar);
                        } else {
                            // Take range from the first event viewable
                            finalEventArray = eventArray.slice(idxOfFirstEventInVisStart, Math.min(idxOfFirstEventInVisStart + maxEventsToDisplayPerCalendar, eventArray.length));
                        }

                        // TEAMCAL-3855 we only need to push parent calendar name in truncatedSubCalendarNames. Child sub calendar name in here does not make sense
                        truncatedSubCalendarNames.push(CalendarPlugin.getParentSubCalendar(calendarDiv, eventArray[0].subCalendarId).name);
                    } else {
                        finalEventArray = eventArray;
                    }

                    finalEventsMap[subCalendarId] = finalEventArray;
                });

                if (truncatedSubCalendarNames.length) {
                    var eventsTruncatedMessageContainer = $(".events-truncated-message-container", calendarDiv);
                    var sortStringArray = function(stringArray) {
                        stringArray.sort(function(nameLeft, nameRight) {
                            return nameLeft > nameRight ? 1 : (nameRight > nameLeft ? -1 : 0);
                        });
                    };
                    var generateTruncatedSubCalendarNamesList = function(subCalendarNamesArray) {
                        var subCalendarNamesList = $(document.createElement("ul"));
                        $.each(subCalendarNamesArray, function(subCalendarNameIdx, subCalendarName) {
                            subCalendarNamesList.append($(document.createElement("li")).text(subCalendarName));
                        });

                        return subCalendarNamesList;
                    };

                    var truncatedSubCalendarNamesList;
                    if (reset) {
                        sortStringArray(truncatedSubCalendarNames);
                        truncatedSubCalendarNamesList = generateTruncatedSubCalendarNamesList(truncatedSubCalendarNames);
                    } else {
                        var existingSubCalendarNames = [];

                        var existingTruncatedSubCalendarNames = $.map($("ul li", eventsTruncatedMessageContainer), function(subCalendarNameListItem) {
                            return $(subCalendarNameListItem).text();
                        });

                        var subCalendarNames = $.map(this.getSubCalendars(calendarDiv), function(subCalendar) {
                            return subCalendar.name;
                        });

                        $.each(existingTruncatedSubCalendarNames, function(existingTruncatedSubCalendarNameIdx, existingTruncatedSubCalendarName) {
                            if ($.inArray(existingTruncatedSubCalendarName, subCalendarNames) > -1 )
                                existingSubCalendarNames.push(existingTruncatedSubCalendarName);
                        });

                        $.each(truncatedSubCalendarNames, function(truncatedSubCalendarNameIdx, truncatedSubCalendarName) {
                            if (-1 === $.inArray(truncatedSubCalendarName, existingSubCalendarNames))
                                existingSubCalendarNames.push(truncatedSubCalendarName);
                        });

                        sortStringArray(existingSubCalendarNames);
                        truncatedSubCalendarNamesList = generateTruncatedSubCalendarNamesList(existingSubCalendarNames);
                    }

                    AJS.messages.warning(eventsTruncatedMessageContainer.empty(), {
                        title: AJS.I18n.getText("calendar3.warning.eventsdropped.title"),
                        body: $(document.createElement("div")).append(truncatedSubCalendarNamesList).html()
                    });

                    CalendarTour.start();

                    var finalEvents = [];
                    $.each(finalEventsMap, function(subCalendarId, eventsArray) {
                        $.merge(finalEvents, eventsArray);
                    });
                    return finalEvents;
                } else {
                    return events;
                }
            },

            isCalendarInEditMode : function(calendarDiv) {
                return this.getParameter(calendarDiv, "readOnly") !== "true";
            },

            isEventEditable : function(calendarDiv, event) {
                return this.isCalendarInEditMode(calendarDiv)
                    && this.isSubCalendarEventsUpdatable(calendarDiv, this.getSubCalendar(calendarDiv, event.subCalendarId))
                    && event.editable;
            },

            isEventDeletable : function(calendarDiv, event) {
                var subCalendar = CalendarPlugin.getSubCalendar(calendarDiv, event.subCalendarId);
                return CalendarPlugin.isEventEditable(calendarDiv, event) && !Confluence.TeamCalendars.isJiraSubCalendar(subCalendar);
            },

            getEventDetailsDialog : function(calendarDiv, event, target, inlineDialogOptions) {
                return ManageEvent(CalendarPlugin, cache).getEventDetailsDialog(calendarDiv, event, target, inlineDialogOptions);
            },

            updateEvent : function(calendarDiv, data, errorCallback, successCallback) {
                ManageEvent(CalendarPlugin, cache).updateEvent(calendarDiv, data, errorCallback, successCallback);
            },

            setSubCalendarSpinnerIconVisible : function(calendarDiv, visible) {
                var deferred = $.Deferred();
                var that = this;
                this.spinnerDeferTasks.push(deferred.promise());

                var toggleSpinner = function (shouldVisible) {
                    var spinnerImage = $(".calendar-panel .right-controls .spinner, .calendar-toolbar .spinner", calendarDiv);
                    if (shouldVisible)
                        spinnerImage.removeClass("invisible");
                    else
                        spinnerImage.addClass("invisible");

                    // TEAMCAL-2753
                    that._toggleEnableButton($(".page-prev", calendarDiv), !shouldVisible);
                    that._toggleEnableButton($(".page-next", calendarDiv), !shouldVisible);
                };

                if (visible)
                {
                    // we trust the caller to open the spinner
                    toggleSpinner(visible);
                }

                // when every promise in array are done then should turn off spinner
                $.when.apply($, this.spinnerDeferTasks).done(function(){
                    toggleSpinner(false);
                    this.spinnerDeferTasks = [];
                });

                // Sometime caller might forget to resolve. Should't trust them in this case
                var timeoutId = setTimeout(function(){
                    deferred.resolve();
                }, 10 * 1000);

                return {
                    resolve: function(){
                        deferred.resolve();
                        clearTimeout(timeoutId);
                    }
                }
            },

            _toggleEnableButton: function ($el, isEnable) {
                $el.attr('aria-disabled', !isEnable);

                if (isEnable) {
                    $el.removeAttr('disabled');
                } else {
                    $el.attr('disabled', 'disabled');
                }
            },

            reloadSubCalendarDisableEvent: function(calendarDiv, data) {
                if(data.uid && (data.originalEventType !== data.eventType || data.originalSubCalendarId !== data.subCalendarId))
                {
                    var disableEventTypes = CalendarPlugin.getSubCalendar(calendarDiv, data.subCalendarId).disableEventTypes;
                    for (var i = 0; i < disableEventTypes.length; i++) {
                        if(disableEventTypes[i] === data.eventType) {
                            disableEventTypes.splice(i, 1);
                            break;
                        }
                    }

                    CalendarPlugin.getSubCalendar(calendarDiv, data.subCalendarId).disableEventTypes = disableEventTypes;
                }
            },

            initCalendarToolbar : function(calendarDiv) {
                var that = this;

                $(".feedback-form-trigger", calendarDiv).click(function() {
                    var feedbackDialog = new AJS.Dialog(700, 512);

                    feedbackDialog.addHeader(AJS.I18n.getText("calendar3.pluginfeedback"));
                    feedbackDialog.addPanel("", "<div class='loading-message'></div><iframe src='https://atlassian.wufoo.com/forms/team-calendars-feedback/' frameborder='0'></iframe>", "calendar-feedback-dialog-panel");

                    var feedbackDialogContent = feedbackDialog.getCurrentPanel().body;
                    var loadingMessageDiv = $(".loading-message", feedbackDialogContent).text(AJS.I18n.getText("calendar3.loading"));
                    $("iframe", feedbackDialogContent).load(function() {
                        loadingMessageDiv.remove();
                    });

                    feedbackDialog.addCancel(AJS.I18n.getText("cancel.name"), function() {
                        feedbackDialog.hide();
                        return false;
                    });
                    feedbackDialog.show();

                    return false;
                });

                $(".change-view", calendarDiv).click(function() {
                    that.hideInlineAuiDialogs();

                    var changeViewButton = $(this);

                    CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("changeView", changeViewButton.data("viewName"));

                    var context = CalUtil.getCalendarContext(calendarDiv);

                    Confluence.TeamCalendars.fireEventForAnalytics("view." + changeViewButton.data("analyticsViewName") + ".render." + context);

                    return false;
                });

                $(".today", calendarDiv).click(function() {
                    that.hideInlineAuiDialogs();

                    cache.removeAllCalendars(); //We need to invalidate the cache when we go to today. See calendar-data-cache.js for details.
                    CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("today");

                    return false;
                });

                $(".page-prev", calendarDiv).click(function() {
                    that.hideInlineAuiDialogs();

                    var calendarPanel = CalendarPlugin.getCalendarPanel(calendarDiv);

                    delete calendarPanel.fullCalendar("getView").daysMore;

                    if (calendarPanel.fullCalendar("getView").name === "basicDay")
                        calendarPanel.fullCalendar("incrementDate", 0, 0, -parseInt(CalendarPlugin.getParameter(calendarDiv, "maxUpcomingDays")));
                    else
                        calendarPanel.fullCalendar("prev");

                    return false;
                });

                $(".page-next", calendarDiv).click(function() {
                    that.hideInlineAuiDialogs();

                    var calendarPanel = CalendarPlugin.getCalendarPanel(calendarDiv);

                    delete calendarPanel.fullCalendar("getView").daysMore;

                    if (calendarPanel.fullCalendar("getView").name === "basicDay")
                        calendarPanel.fullCalendar("incrementDate", 0, 0, parseInt(CalendarPlugin.getParameter(calendarDiv, "maxUpcomingDays")));
                    else
                        calendarPanel.fullCalendar("next");

                    return false;
                });
            },

            getStringAsHex : function(aString) {
                var hashString = "";
                if (aString) {
                    var stringLength = aString.length;
                    for (var charIndex = 0; charIndex < stringLength; ++charIndex) {
                        var hashStringOfChar = aString.charCodeAt(charIndex);
                        hashString += hashStringOfChar.length > 1 ? hashStringOfChar : "0" + hashStringOfChar;
                    }
                }

                return hashString
            },

            formatDate : function(calendarDiv, date, format, formattedCallback) {
                if (formattedCallback) {
                    var isDateArray = $.isArray(date);
                    if (isDateArray && !date.length) {
                        formattedCallback();
                        return;
                    }

                    var data = {
                        date: $.map(isDateArray ? date : [ date ], function(dateToFormat) {
                            return $.fullCalendar.formatDate(dateToFormat, "ddMMyyyyHHmm");
                        }),
                        pattern : format
                    };

                    $.ajax({
                        cache: false,
                        data: data,
                        dataType: "json",
                        error: function() {
                            formattedCallback(AJS.format(AJS.I18n.getText("calendar3.error.failedtoformatdate"), data.date.join(", ")));
                        },
                        success: function(formattedDates) {
                            formattedCallback(isDateArray ? formattedDates : formattedDates[0]);
                        },
                        timeout: CalendarPlugin.ajaxTimeout,
                        url: CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/util/format/date.json")
                    });
                }
            },

            initWhatsNew : function(calendarDiv) {
                var whatsNewContainer = $(".whatsnew");

                if (whatsNewContainer.length) {
                    whatsNewContainer.removeClass("hidden");

                    var dismissWhatsNew = function(dismissedCallback) {
                        Confluence.TeamCalendars.suppressMessage(
                            calendarDiv,
                            "MESSAGE_KEY_PREFIX_WHATSNEW_" + CalendarPlugin.getParameter(calendarDiv, "pluginVersion"),
                            function() {
                                if ($.isFunction(dismissedCallback))
                                    dismissedCallback();
                            }
                        );
                    };

                    $("button", whatsNewContainer).click(function() {
                        window.open($(this).data("url"), "_blank");
                        return false;
                    });

                    $(".aui-iconfont-close-dialog", whatsNewContainer).click(function() {
                        dismissWhatsNew(function() {
                            whatsNewContainer.addClass("hidden");
                        });
                    });
                }
            },

            initButtons: function(calendarDiv) {
                new CalendarNavigationButtonsView({
                    el: "#navigation",
                    calendarDiv: calendarDiv,
                    CalendarPlugin: this

                }).render();

                new CalendarRestrictionButtonsView({
                    el: "#calendar-restriction-buttons",
                    calendarDiv: calendarDiv,
                    CalendarPlugin: this
                });
            },

            getSubCalendarRestrictionsDialog : function(calendarDiv, subCalendar) {
                var subCalendarEditDialog = this.showSubCalendarEdit(calendarDiv, subCalendar);
                var editDialogView = subCalendarEditDialog.belongedView;
                editDialogView.showRestrictionOption();
                return subCalendarEditDialog;
            },

            removeSubCalendarDialog : function(calendarDiv, subCalendar) {
                var calendarRemoveDialog = new CalendarRemoveDialog({calendarPlugin : this, calendarDiv: calendarDiv, subCalendar: subCalendar});
                calendarRemoveDialog.render();
            },

            getSubCalendarFeatureDiscoveryDialog : function(calendarDiv, subCalendar) {

                var calendarFeatureDiscoveryDialog = new CalendarFeatureDiscoveryDialog({calendarPlugin : this,
                    calendarDiv: calendarDiv, subCalendar: subCalendar});

                return {
                    show : function() {
                        calendarFeatureDiscoveryDialog.render();
                    }
                };
            },

            isAutoConvertSupported : function(calendarDiv) {
                return this.getParameter(calendarDiv, "autoConvertSupported") === "true";
            },

            getSubCalendarShareDialog : function(calendarDiv, subCalendar) {
                var subCalendarEditDialog = this.showSubCalendarEdit(calendarDiv, subCalendar);
                var editDialogView = subCalendarEditDialog.belongedView;
                editDialogView.showShareOption();
                return subCalendarEditDialog;
            },

            getSubCalendarIcalAddressDialog : function(calendarDiv, subCalendar) {
                var subCalendarEditDialog = this.showSubCalendarEdit(calendarDiv, subCalendar);
                var editDialogView = subCalendarEditDialog.belongedView;
                editDialogView.showSubscriptionOption();
                return subCalendarEditDialog;
            },

            initCalendarDiv : function(calendarDiv) {
                var callbackHandler = CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv);
                this.initCalendarToolbar(calendarDiv);
                //init calendar panel
                SubCalendarPanel(CalendarPlugin, calendarDiv).initSubCalendarPanel();

                this.initWhatsNew(calendarDiv);
                this.initButtons(calendarDiv);

                $(document).keydown(function(event) {
                    if (event.keyCode === 27) {
                        CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("unselect");
                    }
                });

                if (Confluence.TeamCalendars.shouldShowTimezoneSetup()) {
                    Confluence.TeamCalendars.Dialogs.getTimeZoneSetupDialog(callbackHandler).show();
                } else {
                    callbackHandler.showCalendarWizard();
                }
            },


            getRenderedMacroCallbackHandler : function(calendarDiv) {
                return {
                    isProcessingSubCalendar : function() {
                        return CalendarPlugin.isProcessingSubCalendar(calendarDiv);
                    },

                    setProcessingSubCalendar : function (aBool) {
                        return CalendarPlugin.setProcessingSubCalendar(calendarDiv, aBool);
                    },

                    setSubCalendarSpinnerIconVisible : function(aBool) {
                        return CalendarPlugin.setSubCalendarSpinnerIconVisible(calendarDiv, aBool);
                    },

                    getIncludedCalendars : function() {
                        return CalendarPlugin.getParameter(calendarDiv, "include");
                    },

                    mergeSubCalendarObjectsToArray : function(arrayWithSubCalendarObject) {
                        return CalendarPlugin.mergeSubCalendarObjectsToArray(arrayWithSubCalendarObject);
                    },

                    showAjaxUpdateError : function(XMLHttpRequest, textStatus, errorThrown) {
                        CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);
                    },

                    showAjaxError : function(XMLHttpRequest, textStatus, errorThrown, errorClass) {
                        CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, errorClass)
                    },

                    showHTMLGenericError: function(container, messageResponse, errorClass) {
                        CalendarPlugin.showHTMLGenericError(container, messageResponse, errorClass);
                    },

                    setGenericUpdateError : function() {
                        CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);
                    },

                    setGenericErrors : function(message, errorClass) {
                        Confluence.TeamCalendars.setGenericErrors(calendarDiv, null, errorClass)
                    },

                    setParameter : function(configKey, value) {
                        CalendarPlugin.setParameter(calendarDiv, configKey, value)
                    },

                    getParameter : function(configKey) {
                        return CalendarPlugin.getParameter(calendarDiv, configKey);
                    },

                    setSubCalendar: function(subCalendarId, payload) {
                        CalendarPlugin.setSubCalendar(subCalendarId, calendarDiv, payload);
                    },

                    setSubCalendars : function(newCalendars, payload) {
                        CalendarPlugin.setSubCalendars(calendarDiv, payload);
                    },

                    reloadSubCalendar : function(subCalendarId) {
                        CalendarPlugin.reloadSubCalendar(calendarDiv, subCalendarId);
                    },

                    getSubCalendars : function() {
                        return CalendarPlugin.getSubCalendars(calendarDiv)
                    },

                    updateAvailableSubCalendarsInSubCalendarPanel : function() {
                        CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                    },

                    // for single calendar page => update description and name of calendar
                    refreshCalendarInfo: function(subCalendars) {
                        if(CalUtil.isSingleCalendarView(calendarDiv) && subCalendars.length) {
                            $("#title-text span").text(subCalendars[0].name);
                            $(".calendar-description p").text(subCalendars[0].description);
                        }
                    },

                    shouldShowFeatureDiscoveryDialog : function(subCalendarId) {
                        return CalendarPlugin.shouldShowFeatureDiscoveryDialog(calendarDiv, subCalendarId);
                    },

                    getSubCalendarFeatureDiscoveryDialog : function(subCalendarId) {
                        CalendarPlugin.getSubCalendarFeatureDiscoveryDialog(calendarDiv, CalendarPlugin.getSubCalendar(calendarDiv, subCalendarId)).show();
                    },

                    getNextCalendarColor : function() {
                        return CalendarPlugin.getNextUnusedSubCalendarColor(calendarDiv);
                    },

                    isAutoWatchSet : function() {
                        return CalendarPlugin.getParameter(calendarDiv, "autowatch") === "true";
                    },

                    refreshCachedSubCalendars : function(successCallback, errorCallback) {
                        CalendarPlugin.refreshCachedSubCalendars(calendarDiv, successCallback, errorCallback);
                    },

                    handleImport : function(subcalendarId) {
                        this.refreshCachedSubCalendars(function() {
                            CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                            if (CalendarPlugin.shouldShowFeatureDiscoveryDialog(calendarDiv)) {
                                CalendarPlugin.getSubCalendarFeatureDiscoveryDialog(calendarDiv, CalendarPlugin.getSubCalendar(calendarDiv, subcalendarId)).show();
                            }
                        }, function(XMLHttpRequest, textStatus, errorThrown) {
                            CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);
                        });

                        CalendarTour.start(subcalendarId);
                    },

                    isCalendarInEditMode : function() {
                        return CalendarPlugin.isCalendarInEditMode(calendarDiv);
                    },

                    suppressMessage : function(messageKey, successCallback) {
                        Confluence.TeamCalendars.suppressMessage(calendarDiv, messageKey, successCallback)
                    },

                    showCalendarWizard : function() {
                        var showPopularWelcomeDialog = function() {
                            Confluence.TeamCalendars.Dialogs.getSubCalendarSubscribeDialog({
                                heading: AJS.I18n.getText("calendar3.welcometoconfluencecalendars"),
                                callbackHandler : CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv),
                                id: "welcome-to-popular-dialog"
                            }).show();
                        };

                        var showCalendarDialog = function() {
                            Confluence.TeamCalendars.Dialogs.getAddDialog(
                                CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv),
                                {
                                    title : AJS.I18n.getText("calendar3.welcometoconfluencecalendars"),
                                    addClass : "create-calendar-first-time"
                                }
                            )
                        };

                        var isBlueprint = AJS.Meta.get("space-key") ? (CalUtil.getParamsFromUrl()["openAddCalDialog"] === "true") : false;

                        if (isBlueprint) {
                            if (CalUtil.isValidLicense()) {
                                showCalendarDialog();
                            }
                        } else if ("true" === CalendarPlugin.getParameter(calendarDiv, "isShowCalendarWizard")) {
                            Confluence.TeamCalendars.showCalendarPopupHaveAnEmptySubcalendar(showPopularWelcomeDialog, showCalendarDialog)
                        }
                    },

                    getSubCalendarsWhichCanAddEvents : function() {
                        return CalendarPlugin.getSubCalendarsWhichCanAddEvents(calendarDiv);
                    },

                    updateCustomEventType: function(subCalendarId, customEventTypeData) {
                        CalendarPlugin.updateCustomEventType(calendarDiv, subCalendarId, customEventTypeData);
                    }
                }
            },

            onTeamCalendarsLoaded : function() {
                // Only render favicon on user calendar and space calendar pages.
                if ($('.user-calendar, .space-calendar').length > 0) {
                    Favicon.render();
                }
                $("div.plugin-calendar:not(.init-started)").each(function() {
                    var calendarDiv = $(this);
                    calendarDiv.addClass('init-started');

                    var displayWeekNumber = $("#team-calendars-display-week-number").attr("content");
                    CalendarPlugin.setParameter(calendarDiv, "displayWeekNumber", displayWeekNumber);

                    if (!CalendarPlugin.getParameter(calendarDiv, "defaultView")) {
                        var calendarPanel = CalendarPlugin.getCalendarPanel(calendarDiv).text(AJS.I18n.getText("calendar3.loading"));
                        $.ajax({
                            cache : false,
                            dataType : "json",
                            error : function() {
                                calendarPanel.empty();
                                CalendarPlugin.init(calendarDiv);
                            },
                            success : function(userPreference) {
                                // In the past, there was basicDay view. Now that it has been removed, we need to switch the user's view accordingly.
                                CalendarPlugin.setParameter(calendarDiv, "defaultView", userPreference.view === "agendaDay" ? "basicDay" : userPreference.view);
                                calendarPanel.empty();
                                CalendarPlugin.init(calendarDiv);
                            },
                            timeout: CalendarPlugin.ajaxTimeout,
                            url : CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/preferences.json")
                        });
                    } else {
                        var isInDashboardAsUpcomingEvents = calendarDiv.closest(".dashboard-calendar-container");
                        if (isInDashboardAsUpcomingEvents) {
                            var delayedCalendarInit = setInterval(function() {
                                CalendarPlugin.init(calendarDiv);
                                clearInterval(delayedCalendarInit);
                            }, 100);
                        } else {
                            CalendarPlugin.init(calendarDiv);
                        }
                    }
                });

                //resize calendar when user drags the splitter
                var splitter = $(".ia-splitter-handle-highlight");
                splitter.mousedown(function(){
                        splitter.on("mousemove", function () {
                            $(window).trigger("resize");
                        });
                    })
                    .mouseup(function(){
                        $(window).trigger("resize");
                        splitter.off("mousemove")
                    });

                //resize calendar when user collapses side bar
                $(".expand-collapse-trigger").click(function(){
                    $(window).trigger("resize");
                });
            }
        };

        $(function() {
            CalendarPlugin.isPageUnloading = false;

            AJS.$(window).bind('beforeunload', function() {
                CalendarPlugin.isPageUnloading = true;
            });

            // For the ability to delete an event pressing backspace/delete while the event details callout is visible
            $(document).keydown(function(jsEvent) {
                var doNotPreventDefault = true;

                $(".aui-inline-dialog:visible:first .event-details-popup").each(function() {
                    if (jsEvent.keyCode === 8 || jsEvent.keyCode === 46) {
                        $(".event-delete", this).click();
                        doNotPreventDefault = false;
                    }
                });

                return doNotPreventDefault;
            });

            //resize calendar when user uses [ shortcut
            $("body").keyup(function(event){
                if((event.keyCode ? event.keyCode : event.which) === 219) {
                    $(window).trigger("resize");
                }
            });
        });

        return CalendarPlugin;
    }
);
