// If you think this code is confusing I agree with you.
// See https://developer.atlassian.com/display/CONFDEV/Including+Information+in+your+Macro+for+the+Macro+Browser
// The reason it exists is to ensure that a value is set for the id parameter when a new macro is created.

AJS.bind("init.rte", function () {

    var generateId = function (){
        return Math.random().toString(36).substring(2);
    };

    //handle copy and paste Event Macro
    tinymce.activeEditor.onPostProcess.add(function(ed, pasteText) {
        try {
            //hack to get pasted text
            if (pasteText.getInner) {
                // find out whether pasted text contains macro (including nested macro) or not
                if(pasteText.content.indexOf("editor-inline-macro") === -1) {
                    return;
                }

                // help JQuery to deal with all html element which has same level
                var $pastedElement = $('<div>').html(pasteText.content);
                $pastedElement.find('.editor-inline-macro').each(function(index, macroNode) {
                    var $macroNode = $(macroNode);
                    var macroDeserializer = Confluence.MacroParameterSerializer;
                    var isMacro = $macroNode.hasClass('editor-inline-macro');
                    if (isMacro) {
                        var macroName = $macroNode.attr("data-macro-name");
                        if (macroName === "event") {
                            var params = macroDeserializer.deserialize($macroNode.attr("data-macro-parameters"));
                            params.id = generateId();
                            $macroNode.attr("data-macro-parameters", macroDeserializer.serialize(params));
                        }
                    }
                });

                // get back the pasted text
                pasteText.content = $pastedElement.html();
            }
        } catch(err){
            if (AJS.logError){
                AJS.logError("Could not parse paste content to handle copy Event Macro", err);
            }
        }
    });

    // Make sure a value is set for the id field.
    AJS.MacroBrowser.setMacroJsOverride("event", {
        beforeParamsRetrieved : function(paramMap, macro, sharedParamMap) {
            var id = AJS.$("#macro-param-id").val();
            if (!id) {
                id = generateId();
                //If no id generate a random one.
                AJS.$("#macro-param-id").val(id);
                paramMap['id'] = id;
            }

            return paramMap;
        }
    });

    // Seems like we have to make sure this exists ourselves...
    AJS.MacroBrowser.getMacroJsOverride("event").fields = {};

    //Hide the id field.
    AJS.MacroBrowser.getMacroJsOverride("event").fields.string = {
        "id": function(param) {
            return AJS.MacroBrowser.ParameterFields["_hidden"] (param, {});
        }
    };
});

