define("tc/subcalendar-menu-builder",
    [
        "jquery",
        "underscore",
        "tc/calendar-util"

    ],
    function (
        $,
        _,
        CalUtil
    ) {

        var build = function(calendarDiv, CalendarPlugin, subCalendars) {
            //Things that are set per macro, and not per calendar
            var readOnly = CalendarPlugin.getParameter(calendarDiv, "readOnly") === "true",
                    notificationsEnabled = CalendarPlugin.getParameter(calendarDiv, "isNotificationsEnabled") === "true",
                    hideEditMenuItem = CalendarPlugin.getParameter(calendarDiv, "hideEditMenuItem") === "true",
                    hideRemoveMenuItem = CalendarPlugin.getParameter(calendarDiv, "hideRemoveMenuItem") === "true",
                    hideColourGrid = CalendarPlugin.getParameter(calendarDiv, "hideColorGrid") === "true",
                    userLogin = AJS.Meta.get("remote-user");

            function buildMenuOptions(subCalendar, isChildSubCalendar) {
                if (CalUtil.isSingleCalendarView(calendarDiv)) {
                    _buildSingleCalendarPageMenu(subCalendar, isChildSubCalendar);
                } else {
                    _buildCommonMenu(subCalendar, isChildSubCalendar);
                }
            }

            function _buildCommonMenu(subCalendar, isChildSubCalendar) {
                var isJiraSubCalendar = CalUtil.isJiraSubCalendar(subCalendar),
                        subscriptionSubCalendar = CalUtil.isSubscriptionSubCalendar(subCalendar);

                subCalendar.displayName = subCalendar.name;

                if (CalUtil.isSubscriptionSubCalendar(subCalendar) && !isChildSubCalendar) {
                    subCalendar.menuOptions = {showMenu: false};
                } else {
                    subCalendar.menuOptions = {
                        "showMenu": true,
                        "showAddEvent": !readOnly && !isJiraSubCalendar && subCalendar.eventsEditable,
                        "showNotifications": notificationsEnabled && !isChildSubCalendar,
                        "showEdit": _isEditable(subCalendar) || CalUtil.isSubscriptionSubCalendar(subCalendar),
                        "showView": !hideEditMenuItem && !readOnly && !subCalendar.editable,
                        "showRestrictions": !readOnly && subCalendar.administrable && !isJiraSubCalendar,
                        "showRemove": !hideRemoveMenuItem && !readOnly && subCalendar.editable && ((!isChildSubCalendar || CalUtil.isSubscriptionSubCalendar(subCalendar)) ? true : subCalendar.eventsEditable),
                        "showShareAndSubscribe": subCalendar.eventsViewable && !isJiraSubCalendar,
                        "showSubscribe": !isJiraSubCalendar,
                        "showColourGrid": !hideColourGrid && (subscriptionSubCalendar || isJiraSubCalendar) && userLogin.length > 0,
                        "showReload": subCalendar.reloadable,
                        "showDisplayLink": true
                    };
                }
            }

            function _buildSingleCalendarPageMenu(subCalendar, isChildSubCalendar) {
                _buildCommonMenu(subCalendar, isChildSubCalendar);
                var menuOptions = subCalendar.menuOptions;

                menuOptions.showEdit = false;
                menuOptions.showRemove = false;
                if (CalUtil.isJiraSubCalendar(subCalendar)) {
                    menuOptions.showEdit = true;
                    menuOptions.showRemove = true;
                }
                menuOptions.showRestrictions = false;
                menuOptions.showDisplayLink = false;

                subCalendar.menuOptions = menuOptions;
            }

            function _isEditable(subCalendar) {
                return !readOnly && subCalendar.editable && subCalendar.eventsEditable;
            }

            function _hasReminderSetting(subCalendar, childrenSubCalendar) {
                var eventType = childrenSubCalendar.subscriptionType || childrenSubCalendar.type;
                if (CalUtil.isEventTypeSanbox(eventType) || CalUtil.isJiraType(eventType)) {
                    var period = CalUtil.getPeriodReminderEventTypeSanboxOrJira(subCalendar, eventType);
                    return period !== undefined && period > 0;
                } else if (CalUtil.isCustomEventType(eventType)) {
                    return childrenSubCalendar.customEventTypes[0].periodInMins > 0;
                }
            }

            _.each(subCalendars, function (subCalendar) {
                //Set menu options for parent calendar
                buildMenuOptions(subCalendar, false);

                if (subCalendar.childSubCalendars) {
                    _.each(subCalendar.childSubCalendars, function (childSubCalendar) {

                        var typeNameKey = childSubCalendar.typeKey;
                        var typeName = CalendarPlugin.getEventTypeNames(typeNameKey);
                        if (CalUtil.isSubscriptionSubCalendar(childSubCalendar)) {
                            buildMenuOptions(childSubCalendar, true);

                            childSubCalendar.menuOptions = $.extend(childSubCalendar.menuOptions, {
                                "showDisplayLink": false
                            });
                        } else if (CalUtil.isJiraSubCalendar(childSubCalendar)) {
                            buildMenuOptions(childSubCalendar, true);

                            childSubCalendar.menuOptions = $.extend(childSubCalendar.menuOptions, {
                                "showReminder": userLogin.length > 0 && _hasReminderSetting(subCalendar, childSubCalendar),
                                "showSettingReminder": userLogin.length > 0 && !_hasReminderSetting(subCalendar, childSubCalendar) && _isEditable(subCalendar),
                                "showDisplayLink": false
                            });
                        } else {
                            //Simple case for uninteresting child calendars
                            childSubCalendar.menuOptions = {
                                "showMenu": true,
                                "showColourGrid": userLogin.length > 0,
                                "showReload": true,
                                "showReminder": userLogin.length > 0 && _hasReminderSetting(subCalendar, childSubCalendar),
                                "showSettingReminder": userLogin.length > 0 && !_hasReminderSetting(subCalendar, childSubCalendar) && _isEditable(subCalendar)
                            };
                            childSubCalendar.displayName = typeName;
                        }

                    });
                }
            });
        };

        return {
            build: build
        };
    }
);