define("tc/child-subcalendar-entry-view",
    [
        "jquery",
        "tc-backbone",
        "tc/calendar-util",
        "tc/subcalendar-menu-view",
        "tc/subcalendar-displayer"
    ],
    function (
        $,
        Backbone,
        CalUtil,
        SubCalendarMenuView,
        SubCalendarDisplayer
    ) {

        "use strict";

        var ChildSubCalendarEntryView = Backbone.View.extend({
            initialize: function(options) {
                this.cache = options.cache;
                this.parentSubCalendar = options.parentSubCalendar;
                this.childSubCalendar = options.childSubCalendar;
                this.customEventType = options.customEventType;
                this.CalendarPlugin = options.CalendarPlugin;
                this.calendarDiv = options.calendarDiv;

                this.parentView = options.parentView;
                this.template = options.template;
            },

            events: {
                "hover .child-subcalendar": "_onHover",
                "click .child-subcalendar-name": "_onClick"
            },

            render: function() {
                this.$el.html(this.template({
                    "childSubCalendar": this.childSubCalendar,
                    "customEventType": this.customEventType
                }));

                this.entryView = this.$(".child-subcalendar");

                var options = {
                    "cache": this.cache,
                    "CalendarPlugin": this.CalendarPlugin,
                    "calendarDiv": this.calendarDiv,

                    "subCalendar": this.childSubCalendar,
                    "parentSubCalendar": this.parentSubCalendar,
                    "subCalendarEntryView": this.entryView,

                    "autoConvertSupported": this.CalendarPlugin.isAutoConvertSupported(this.calendarDiv),
                    "subCalendarClasses": this.CalendarPlugin.getParameter(this.calendarDiv, "subCalendarColorClass")
                };

                if (this.customEventType) {
                    options.template = Confluence.TeamCalendars.Templates.customEventTypeMenu;
                } else {
                    options.template = Confluence.TeamCalendars.Templates.childSubCalendarMenu;
                }

                this.entryView.append(new SubCalendarMenuView(options).render());

                this._ellipsisChildSubCalendarName();

                this.subcalendarDisplayer = new SubCalendarDisplayer({
                    CalendarPlugin: this.CalendarPlugin,
                    calendarDiv: this.calendarDiv,
                    entryView: this.entryView,
                    subCalendar: this.childSubCalendar,
                    parentView: this.parentView,
                    parentSubCalendar: this.parentSubCalendar
                });

                return this.$el;
            },

            _ellipsisChildSubCalendarName: function () {
                var $childSubCalendarName = this.$(".child-subcalendar-name");
                if(!$childSubCalendarName.attr("threedots")) {
                    $childSubCalendarName.attr("title", this.$(".ellipsis_text").text());
                }
            },

            _onHover: function() {
                this.entryView.toggleClass("active-child-subcalendar");
            },

            _onClick: function() {
                this.subcalendarDisplayer.toggleVisibility();
            }
        });

        return ChildSubCalendarEntryView;
    }
);
