define("tc/reindex-calendar-contenttype-settings",
    [
        "ajs",
        "tc/templates",
        "tc/rebuild-data-settings"
    ],
    function (
        AJS,
        Templates,
        RebuildDataSetting
     )
    {
        "use strict";

        var ReindexCalendarContentTypeSetting = RebuildDataSetting.extend({

            initialize: function () {
                var options = {
                    url: "/calendarcontenttype/reindex",
                    container: "#reindex-calendar-contenttype",
                    button: "button.reindex",
                    loggingDiv: "#logs-reindex-calendar-contenttype"
                };

                RebuildDataSetting.prototype.initialize.apply(this, [options]);
            },

            renderSuccess: function () {
                return Templates.rebuildData(this.buildRenderParams(
                        "success",
                        AJS.I18n.getText("calendar3.admin.reindexcontenttype.info.success.label"),
                        AJS.I18n.getText("calendar3.admin.reindexcontenttype.info.success")))

            },

            renderError: function () {
                return Templates.rebuildData(that.buildRenderParams(
                        "fail",
                        AJS.I18n.getText("calendar3.admin.reindexcontenttype.info.fail.label"),
                        AJS.I18n.getText("calendar3.admin.reindexcontenttype.info.fail")))

            },

            renderProcessing: function () {
                return Templates.rebuildData(this.buildRenderParams(
                        "process",
                        AJS.I18n.getText("calendar3.admin.reindexcontenttype.info.process.label"),
                        AJS.I18n.getText("calendar3.admin.reindexcontenttype.info.process")));
            }
        });

        return ReindexCalendarContentTypeSetting;
    });