define("tc/internal-subscription-subcalendar",
    [
        "jquery",
        "tc/templates",
        "tc/calendar-util"
    ],
    function (
        $,
        Templates,
        CalUtil
    )
    {
        "use strict";
        var InternalSubscription = Backbone.View.extend({
            getDialog : function(editDialog, subCalendar, callbackHandler) {
                var helper;
                var editForm;
                var populateForm = function(helper, editForm) {
                    helper.resetFieldErrors();

                    if (helper.isNewCalendar()) {
                        helper.setFormModeCreate();
                        helper.setHeading(AJS.I18n.getText("calendar3.newsub-calendar"), editDialog);
                        helper.setSubCalendarIdField("");
                        helper.setSubscriptionIdField("");
                        helper.setNameField("");
                        helper.setDescriptionField("");
                        helper.setColorField(callbackHandler.getNextCalendarColor());
                        helper.setSpaceToDefault();
                        helper.setTimeZoneIdDisplayField("");
                    } else {
                        helper.setFormModeEdit();
                        helper.setHeading(subCalendar.name, editDialog);
                        helper.setSubCalendarIdField(subCalendar.id);
                        helper.setSubscriptionIdField(subCalendar.subscriptionId || "");
                        helper.setNameField(subCalendar.name);
                        helper.setDescriptionField(subCalendar.description);
                        helper.setColorField(subCalendar.color);
                        helper.setSpaceKeyField(subCalendar.spaceKey);
                        helper.setSpaceKeyAutocompleteField(subCalendar.spaceName);
                        helper.setTimeZoneIdDisplayField(subCalendar.timeZoneId);

                        if (!(subCalendar.restrictable && subCalendar.administrable)) {
                            $(".field-group-permissions", editForm).remove();
                        }
                    }

                    var textInputs = $("textarea[name='description'], input[name='spaceKeyAutocomplete']", editForm);
                    if (callbackHandler.isCalendarInEditMode()) {
                        textInputs.removeAttr("readonly");
                    } else {
                        helper.setFormModeReadOnly();
                        textInputs.attr("readonly", "readonly");
                    }

                    // hidden space field when create TC on space
                    if(helper.isNewCalendar() && AJS.Meta.get("space-key")) {
                        var spaceDiv = $(".field-group-space-permission", editForm);
                        spaceDiv.addClass("hidden");
                    }
                };

                return {
                    initializeForm: function(callBackCancel) {
                        editDialog.addHeader(AJS.I18n.getText("calendar3.newsub-calendar"));
                        editDialog.addPanel(AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.editcalendar.panel.general"), Templates.editInternalSubcalendar(), "calendar-dialog-panel");

                        editForm = $("form.sub-calendar-edit-form", editDialog.getCurrentPanel().body);
                        helper = Confluence.TeamCalendars.getEditCalendarDialogHelper(editForm, subCalendar, callbackHandler);

                        helper.initSpaceDropDown();
                        helper.initOkButton(AJS.I18n.getText("ok"), editDialog);
                        helper.initCloseButton(editDialog, callBackCancel);
                        populateForm(helper, editForm);

                        return editForm;
                    },

                    getFormDataAsAjaxData : function() {
                        var data = {
                            type : "internal-subscription",
                            subCalendarId : $("input[name='subCalendarId']", editForm).val(),
                            name : $("input[name='name']", editForm).val(),
                            description : $("textarea[name='description']", editForm).val(),
                            color : $("input[name='color']", editForm).val(),
                            spaceKey : $("input[name='spaceKeyAutocomplete']", editForm).val() ? $("input[name='spaceKey']", editForm).val() : "",
                            location: "subscription://" + $("input[name='subscriptionId']", editForm).val()
                        };

                        CalUtil.putCalendarContextParams(data);

                        return data;
                    },

                    onSubmitStart : function() {
                        helper.disableOkButton(AJS.I18n.getText("calendar3.adding"));
                    },

                    onSubmitEnd : function() {
                        helper.enableOkButton(AJS.I18n.getText("ok"));
                    }
                };
            },
            weight : 1000,
            typeName : AJS.I18n.getText("calendar3.subcalendar.type.unknown")
        });

        return InternalSubscription;
    }

);