/**
 * Confluence 5.7 doesn't have a amd module for skate so we rely in the global version
 * Confluence 5.9 includes skate
 *
 * The old version of skate uses create as callback and the new one uses ready.
 */
require(['ajs', 'tc/init-resources'], function(AJS, Initialiser) {
    var initSkateComponent = function (skate) {
        skate('calendar-container', {
            type: skate.types.CLASS,
            attached: function () {
                Initialiser.requireResources();
            },
            create: function () {
                Initialiser.requireResources();
            },
            ready: function () {
                Initialiser.requireResources();
            }
        });
    };

    var confVersion = AJS.Meta.get('version-number').split('.');
    // any version prior to 5.9 will rely in the global skate
    if (confVersion[0] === '5' && confVersion[1] < 9) {
        initSkateComponent(window.skate);
    } else {
        require(['skate'], function (skate) {
            initSkateComponent(skate);
        });
    }
});