define('tc/init-resources', ['wrm', 'jquery'], function(WRM, $) {
    var removeSpinner = function($elem) {
        return $elem.removeClass('spinner').removeClass('aui-icon').removeClass('aui-icon-wait');
    };

    return {
        requireResources: function() {
            WRM.require([
                'wrc!com.atlassian.confluence.extra.team-calendars.resources-batch'
            ], function () {
                removeSpinner($('div.plugin-calendar'));
                require(['tc/calendar-plugin'], function(CalendarPlugin) {
                    CalendarPlugin.onTeamCalendarsLoaded();
                });
            }).fail(function () {
                removeSpinner($('div.plugin-calendar')).text('Failed to load calendar resources');
            });
        }
    }
});