define("tc/import-subcalendar",
        [
            "jquery",
            "underscore",
            "tc/util",
            "tc-backbone",
            "tc/templates",
            "tc/calendar-util"
        ],
        function (
            $,
            _,
            Util,
            Backbone,
            Templates,
            CalUtil
    )
    {

        "use strict";

        var ImportSubCalendarDialogView = Backbone.View.extend({
            dialog: null, //instance of AJS.ConfluenceDialog,
            //el: will be dialogContent of dialog
            $uploadIframe: null,
            //submit import button
            $submitButton: null,
            options: null, //setting collection of an instance of ImportSubCalendarDialogView

            template: Templates.importSubcalendar(),

            events: {
                "selected.autocomplete-content input[name='spaceKeyAutocomplete']": "_selectSpace",
                "submit .sub-calendar-import-form": "_submit"
            },

            defaults: {
                callbackHandler: null,
                textTitleDialog: AJS.I18n.getText("calendar3.importsubcal"),
                textBtnImport: AJS.I18n.getText("import.name"),
                textLinkCancel: AJS.I18n.getText("cancel.name")
            },

            initialize: function(options){
                this.options = $.extend({}, this.defaults, options);

                if (!this.options.callbackHandler) {
                    AJS.debug("tc/import-subcalendar: requires 'callbackHandler' object");
                }
            },

            render: function(){
                this._createSubCalendarImportDialog();
                this._populateSubCalendarImportForm();

                this.$submitButton = this.dialog.popup.element.find(".submit");
                return this.dialog;
            },

            _createSubCalendarImportDialog: function(){
                var that = this,
                    submit = function() {
                        var editForm = that.$el.find('form.sub-calendar-import-form');
                        editForm.submit();
                        return false;
                    };

                //Do not need to create one more instance of AJS.ConfluenceDialog
                if (this.dialog) {
                    return;
                }

                this.dialog = new AJS.ConfluenceDialog({
                    height : 429,
                    width : 512,
                    onSubmit : submit,
                    id : "import-calendar-dialog"
                });

                this.dialog.addHeader(this.options.textTitleDialog);
                this.dialog.addPanel("", this.template, "calendar-dialog-panel");

                //add button submit for dialog
                this.dialog.addButton(
                    this.options.textBtnImport,
                    submit,
                    "submit"
                );

                //add cancel link for dialog
                this.dialog.addLink(
                    this.options.textLinkCancel,
                    _.bind(this._cancelDialog, this)
                );

                this.el = this.dialog.getCurrentPanel().body;
                this.$el = $(this.el);
                this.$uploadIframe = this.$el.find(".subcalendar-import-result");

                this.delegateEvents(); // this will bind all events once
                //events of backbone cannot bind load event, so we must do it manually
                this.$el.find(".subcalendar-import-result").load(_.bind(this._loadedResultImport, this));
            },

            _populateSubCalendarImportForm: function(){
                this.$el.find("input[name='name'], textarea[name='description'], input[name='spaceKey'], input[name='spaceKeyAutocomplete']").val("");
                this.$el.find("input[name='color']").val(this.options.callbackHandler.getNextCalendarColor());
                this.$el.find(".field-group .error").empty();

                //hidden space field when TC on space
                if(AJS.Meta.get("space-key")) {
                    this.$el.find("input[name='spaceKey']").val(AJS.Meta.get("space-key"));
                    var spaceDiv = $(".field-group-space-permission", this.$el);
                    spaceDiv.css("display", "none");
                }
            },

            _submit: function(){
                this.options.callbackHandler.setProcessingSubCalendar(true);
                this.spinnerDefer = this.options.callbackHandler.setSubCalendarSpinnerIconVisible(true);
                this.$uploadIframe.data("activated", true);
                //disable submit when click
                CalUtil.disableButton(this.$submitButton, AJS.I18n.getText("calendar3.importing.name"));
            },

            _selectSpace: function(e, selection){
                this.$el.find("input[name='spaceKey']").val(selection.content.key);
                this.$el.find("input[name='spaceKeyAutocomplete']").val(selection.content.name);
            },

            _cancelDialog: function(){
                this.dialog.remove();
                this.dialog = null;
                return false;
            },

            _loadedResultImport: function(){
                var that = this;

                if (!this.$uploadIframe.data("activated")) {
                    return;
                }

                var iframeDocument = this.$uploadIframe[0].contentWindow || this.$uploadIframe[0].contentDocument;
                iframeDocument = iframeDocument.document ? iframeDocument.document : iframeDocument;

                var subcalendarId = $(iframeDocument).find(".subcalendar-id").text();

                if ($(".import-timezone-required", iframeDocument).length) { //We could not determine the calendars timezone

                    CalUtil.disableButton(this.$submitButton);

                    //Show a message explaining we need to know the timezone
                    that.$el.find(".tc-need-timezone").show();
                    //Show the timezone field
                    that.$el.find(".tc-field-group-timezone").show();

                    //TODO: need to refactor Confluence.TeamCalendars.populateTimeZoneDropDown
                    // and Confluence.TeamCalendars.getUserTimeZone
                    Confluence.TeamCalendars.populateTimeZoneDropDown(
                        that.$el.find(".tc-field-group-timezone .timeZone"),
                        Confluence.TeamCalendars.getUserTimeZone(),
                        function() {
                            CalUtil.enableButton(that.$submitButton, AJS.I18n.getText("import.name"));
                        },
                        function(XMLHttpRequest, textStatus, errorThrown) {
                            that.options.callbackHandler.showAjaxError(XMLHttpRequest, textStatus, errorThrown);
                        }
                    );

                    // Comment out to deal with AUI on Confluence 5.7
                    //Util.showDialogInUpdatedHeight(that.dialog);
                    that.dialog.updateHeight();
                } else if (!$(".import-successful", iframeDocument).length) {
                    var fieldErrors = [];
                    $(".field-errors input", iframeDocument).each(function() {
                        fieldErrors.push({
                            field : this.name,
                            errorMessages : [ this.value ]
                        });
                    });

                    if (fieldErrors.length) {
                        //TODO: need to refactor Confluence.TeamCalendars.setFieldErrors
                        Confluence.TeamCalendars.setFieldErrors(that.$el.find(".sub-calendar-import-form")[0], fieldErrors);
                        // Comment out to deal with AUI on Confluence 5.7
                        //Util.showDialogInUpdatedHeight(that.dialog);
                        that.dialog.updateHeight();
                    }

                    var errorMessages = [];
                    $(".action-error", iframeDocument).each(function() {
                        errorMessages.push($(this).text());
                    });
                    if (errorMessages.length) {
                        //TODO: need to refactor Confluence.TeamCalendars.setGenericErrors
                        Confluence.TeamCalendars.setGenericErrors(that.el, errorMessages, "error-subcalendar-update");
                    }
                } else {
                    that.dialog.remove();
                    that.options.callbackHandler.handleImport(subcalendarId);
                }

                CalUtil.enableButton(this.$submitButton, AJS.I18n.getText("import.name"));

                if (this.spinnerDefer) this.spinnerDefer.resolve();
                that.options.callbackHandler.setProcessingSubCalendar(false);
            }
    });

        return ImportSubCalendarDialogView;
});
