/* TODO: Remove this once helptips are provided by confluence.
 * This file is a modified version of the one in https://bitbucket.org/atlassian/jira-help-tips.
 * Once help-tips are added to confluence we should be able to remove this file and use AJS.HelpTip instead.
 * However make sure that the AUI version is positioning things correctly in the editor before you do this.
 */

(function($) {
    function nope() { return false; }
    function yep() { return true; }

    var cidCounter = 0, seed = new Date().getTime();

    // TEAMCAL : make sure we use the calendar util component instead of ref to static method like this 
    var restUrl = Confluence.TeamCalendars.getRestBaseUrl() +"/tips";

    // to un-fuck graphite event names
    function cleanAnalyticsName(name) {
        name = "" + (name || "");
        return name.replace(/\./g, "-");
    }

    function analytics(eventId, model) {
        if (AJS.EventQueue && model && model.attributes.id) {
            var event = {};
            var cleanId = cleanAnalyticsName(model.attributes.id);
            event.name = "helptips." + cleanId + "." + eventId;
            event.properties = {};
            AJS.EventQueue.push(event);
        }
    }

    function getCid() {
        return "c" + seed + (cidCounter++);
    }

    var Manager = {
        dismissedTipIds: [],
        loaded: $.Deferred(),
        url: function() { return restUrl; },
        sync: function(verb, data) {
            verb || (verb = "get");
            data || (data = null);
            return $.ajax(this.url(), {
                type: verb,
                context: this,
                dataType: "json",
                contentType: "application/json",
                data: data && JSON.stringify(data),
                processData: false
            }).promise();
        },
        fetch: function() {
            var result = this.sync();
            result.done(function(response) {
                $.merge(this.dismissedTipIds, response);
                this.loaded.resolve();
            });
            return result.promise();
        },
        show: function(showFunction) {
            this.loaded.done(showFunction);
        },
        dismiss: function(tip) {
            var id = tip.attributes.id;
            if (!id) {
                tip._dismissed = true;
            } else {
                this.dismissedTipIds.push(id);
                this.sync("post", {id:id});
            }
        },
        undismiss: function(tip) {
            var id = tip.attributes.id;
            if (!id) {
                tip._dismissed = false;
            } else {
                this.dismissedTipIds.splice($.inArray(id, this.dismissedTipIds), 1);
                this.sync("delete", {id:id});
            }
        },
        isDismissed: function(tip) {
            var id = tip.attributes.id;
            return (id) ? $.inArray(id, this.dismissedTipIds) >= 0 : tip._dismissed;
        }
    };

    var HelpTip = Confluence.TeamCalendars.HelpTip = function(attributes) {
        var anchor;
        this.attributes = $.extend({}, attributes);
        this.attributes.id || (this.attributes.id = false);
        // Map renamed attribute body to bodyHtml
        if (this.attributes.body) {
            this.attributes.bodyHtml = this.attributes.body;
            delete this.attributes.body;
        }
        this.cid = getCid();
        anchor = this.attributes['anchor'];
        delete this.attributes['anchor'];

        this.view = (anchor) ? new AnchoredView(this, anchor) : new UnanchoredView(this);
        this.view.$el.addClass('tc-aui-help-tip');
    };

    Confluence.TeamCalendars.HelpTip.Manager = Manager;

    $.extend(HelpTip.prototype, {
        show: function() {
            var self = this;
            Confluence.TeamCalendars.HelpTip.Manager.show(function() {
                if (!self.isDismissed()) {
                    self.view.show();
                    analytics("shown", self);
                }
            });
        },
        dismiss: function() {
            var reason = cleanAnalyticsName(arguments[0] || "programmatically");
            this.view.dismiss();
            if (!this.isDismissed()) {
                Confluence.TeamCalendars.HelpTip.Manager.dismiss(this);
                analytics("dismissed." + reason, this);
            }
        },
        isVisible: function() {
            return this.view.$el.is(":visible");
        },
        isDismissed: function() {
            return Confluence.TeamCalendars.HelpTip.Manager.isDismissed(this);
        }
    });

    var AnchoredView = function(model, anchor) {
        this.initialize(model, anchor);
    };

    $.extend(AnchoredView.prototype, {
        initialize: function(model, anchor) {
            var self = this;
            var arrowHeight = 9;
            var editorSpace = AJS.$("#rte").height() - anchor.offset().top;
            var minEditorSpace = 200;
            var flipDialog = editorSpace < minEditorSpace;
            var scrollPos = $(AJS.Rte.getEditor().getDoc()).scrollTop();
            this.model = model;
            this.beforeHide = nope;
            this.closeButton = $(Confluence.TeamCalendars.Templates.tipClose());
            this.closeButton.click(function(e) {
                model.dismiss("close-button");
                e.preventDefault();
            });
            this.popup = AJS.InlineDialog(anchor, model.cid, function(content, trigger, show) {
                content.html(Confluence.TeamCalendars.Templates.tipContent(model.attributes));
                content.append(self.closeButton);
                content.unbind('mouseover mouseout');
                content.find(".tc-helptip-link").click(function() {
                    analytics("learn-more.clicked", model);
                });
                show();
            }, {
                // Use a container other than body, so that the positioning works when there are client-rendered banner messages
                container: "#content",
                noBind: true,
                onTop: flipDialog,
                preHideCallback: function() { return self.beforeHide() },
                calculatePositions: function(popup, targetPosition, mousePosition, opts) {
                    // Adjust positions relative to the editor
                    var cssData = AJS.InlineDialog.opts.calculatePositions(popup, targetPosition, mousePosition, opts);

                    if (flipDialog) {
                        cssData.popupCss.top = $("#rte").offset().top + anchor.offset().top - popup.height() - arrowHeight;
                    } else {
                        cssData.popupCss.top = $("#rte").offset().top + (anchor.offset().top - scrollPos) + anchor.height() + arrowHeight;
                    }

                    cssData.popupCss.left = anchor.offset().left;
                    cssData.displayAbove = flipDialog;

                    return cssData;
                }
            }
            );
            this._popupHide = this.popup.hide;
            this.popup.hide = nope;
            this.$el = $(this.popup[0]);
            AJS.$(document).bind("showLayer",function(e,type,layer) {
                if (type === "inlineDialog" && layer.id === model.cid) {
                    AJS.InlineDialog.current = null; // Tips shouldn't be considered InlineDialogs.
                    AJS.$(document.body).unbind("click."+model.cid+".inline-dialog-check");
                    layer._validateClickToClose = nope;
                    layer.hide = nope;
                }
            });
        },
        show: function() {
            var popup = this.popup,

                hidePopup = function(e) {
                    if (!popup.has(e.target).length) {
                        popup.shadow.remove(); //Needed for IE
                        popup.remove();
                    }
                };

            popup.show();

            //Hide the help tip if it the user clicks outside of it.
            AJS.$("#full-height-container").click(hidePopup);

            //Hide the helptip inside the iframe
            AJS.Rte.getEditor().onClick.add(hidePopup);
        },
        dismiss: function() {
            this.beforeHide = yep;
            this._popupHide();
        }
    });

    var UnanchoredView = function(model) {
        this.initialize(model);
    };

    $.extend(UnanchoredView.prototype, {
        initialize: function() {
            this.$el = $("<div></div>");
        },
        show: function() { },
        dismiss: function() { }
    });

    // Load up the user's dismissed tips.
    Manager.fetch();
})(AJS.$);
