jQuery(function($) {
    $("#reset-subscriptions-form").submit(function() {
        $(".button", this).attr("disabled", "disabled");
    });

    var LongRunTaskClient = {
        waitForLongRunTask : function (longRunTaskId, processUpdateCb, status, defer) {
            var d = defer ? defer : $.Deferred();
            var timeout = 2000;
            var url = AJS.contextPath() + "/rest/api/longtask/" + longRunTaskId;
            LongRunTaskClient
                .wait(timeout)
                .done(function () {
                    $.ajax({
                        type: 'GET',
                        contentType: 'application/json',
                        url: url
                        }).done(function (s) {
                            var jsonStatus = s;
                            var progressComplete = parseInt(jsonStatus.percentageComplete, 10);
                            if (jsonStatus.successful) {
                                if (progressComplete >= 100) {
                                    return d.resolve(status);
                                }

                                processUpdateCb(jsonStatus.percentageComplete);
                                return LongRunTaskClient.waitForLongRunTask(longRunTaskId, processUpdateCb, jsonStatus, d);
                            } else {
                                return d.reject(status);
                            }

                    }).fail(d.reject);
                });

            return d.promise();
        },

        wait: function(timeout, context) {
            var deferred = $.Deferred();
            var promise = deferred.promise();

            var timeoutId = setTimeout(function() {
                deferred.resolveWith(context, arguments)
            }, timeout || 0);
            return promise;
        }
    };

    var $encryptePasswordForm = $('#tc-encrypt-password-form');
    var $waitingIcon = $encryptePasswordForm.find('.aui-icon-wait');
    var $submitButton = $encryptePasswordForm.find('.button');
    var $encryptPasswordPanel = $("#tc-password-encryption");
    var $encryptPasswordIcon = $("#tc-password-encryption-icon");
    var $encryptPasswordMsg = $("#tc-password-encryption-msg");
    var longRunTaskId = $encryptePasswordForm.attr("longRunTaskId");
    var messages = $("#tc-password-encryption span.hidden");
    var updateProgressBar = function(percentage) {};
    var enableForm = function (isDone) {
        $waitingIcon.addClass("hidden");
        $submitButton.removeAttr('disabled');
        $encryptPasswordPanel.removeClass();
        $encryptPasswordIcon.removeClass();
        if (isDone) {
            $encryptPasswordPanel.addClass("aui-message success shadowed");
            $encryptPasswordIcon.addClass("aui-icon icon-success");
            $encryptPasswordMsg.html(messages[0].innerHTML);
        } else {
            $encryptPasswordPanel.addClass("aui-message error shadowed");
            $encryptPasswordIcon.addClass("aui-icon icon-error");
            $encryptPasswordMsg.html(messages[1].innerHTML);
        }
    };

    var disableForm = function () {
        $submitButton.attr('disabled', 'disabled');
        $waitingIcon.removeClass("hidden");
    };

    if (longRunTaskId) {
        $waitingIcon.removeClass("hidden");
        LongRunTaskClient.waitForLongRunTask(longRunTaskId, updateProgressBar)
            .fail(enableForm(false))
            .done(enableForm(true));
        $encryptePasswordForm.remove();
    } else {
        $encryptePasswordForm.submit(function () {
            disableForm();
        });
    }
});
