define("tc/full-calendar-option",
    [
        "jquery",
        "tc/manage-event"
    ],
    function (
        $,
        ManageEvent)
    {
        "use strict";
        var FullCalendarOption = function(CalendarPlugin, calendarDiv, cache) {
            return {
                calendarDiv : calendarDiv,
                calendarPlugin : CalendarPlugin,
                defaultView : CalendarPlugin.getParameter(calendarDiv, "defaultView") || "month",
                year : parseInt(CalendarPlugin.getParameter(calendarDiv, "startingYear")),
                month : parseInt(CalendarPlugin.getParameter(calendarDiv, "startingMonth")),
                date : parseInt(CalendarPlugin.getParameter(calendarDiv, "startingDay")),
                header : false,
                firstDay : CalendarPlugin.getParameter(calendarDiv, "firstDayOfWeek"),
                weekends : CalendarPlugin.getParameter(calendarDiv, "hideWeekends") === "false",
                viewRender : function(view) {
                    var highlightViewButton = function() {
                            if (Confluence.TeamCalendars.isPDLEnabled()) {
                                $(".change-view", calendarDiv).removeClass("active");
                                $(".change-view-" + view.name, calendarDiv).addClass("active");
                            } else {
                                $(".change-view", calendarDiv).each(function() {
                                    $(this).closest("li").removeClass("active");
                                });
                                $(".change-view-" + view.name, calendarDiv).closest("li").addClass("active");
                            }
                        };

                    Confluence.TeamCalendars.updateDateDisplay(calendarDiv, view.title);
                    highlightViewButton();

                    if (view.name === "basicDay") {
                        CalendarPlugin.getCalendarPanel(calendarDiv).addClass("borderless");
                    } else {
                        CalendarPlugin.getCalendarPanel(calendarDiv).removeClass("borderless");
                    }

                    if (CalendarPlugin.isCalendarInEditMode(calendarDiv)) {
                        var lastSelectedView = calendarDiv.data("lastSelectedView");
                        if (!lastSelectedView) {
                            calendarDiv.data("lastSelectedView", view.name);
                        } else if (view.name !== lastSelectedView) {
                            calendarDiv.data("lastSelectedView", view.name);
                            $.ajax({
                                cache : false,
                                data : {
                                    view : view.name
                                },
                                dataType : "json",
                                error : function(XMLHttpRequest, textStatus, errorThrown) {
                                    CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_CONFIG_UPDATE);
                                },
                                success : function() {
                                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_CONFIG_UPDATE);
                                },
                                type: "PUT",
                                timeout: CalendarPlugin.ajaxTimeout,
                                url : CalendarPlugin.getCalendarServiceBaseUrl(calendarDiv, "/preferences/view.json")
                            });
                        }
                    }
                },
                allDayText: AJS.I18n.getText("calendar3.allday"),
                firstHour: 8,
                columnFormat : {
                    week: "ddd d"
                },
                titleFormat : {
                    week: "MMM d[ yyyy]{ '&#8212;'[ MMM] d, yyyy}"
                },
                buttonText : {
                    today : AJS.I18n.getText("calendar3.button.today"),
                    month : AJS.I18n.getText("calendar3.button.month"),
                    week : AJS.I18n.getText("calendar3.button.week"),
                    day : AJS.I18n.getText("calendar3.button.list")
                },
                monthNames : CalendarPlugin.getMonthNames(),
                monthNamesShort : CalendarPlugin.getMonthNamesShort(),
                dayNames : CalendarPlugin.getDayNames(),
                dayNamesShort : CalendarPlugin.getDayNamesShort(),
                dayClick : function(date, allDay, jsEvent) {
                    if ($(".event-details-popup:visible").length === 0) {
                        if (CalendarPlugin.getSubCalendarsWhichCanAddEvents(calendarDiv).length) {
                            Confluence.TeamCalendars.Dialogs.getEditEventDialog({
                                    start : date,
                                    localizedStartTime : allDay ? CalendarPlugin.getDefaultStartTime(calendarDiv) : null,
                                    localizedEndTime : allDay ? CalendarPlugin.getDefaultEndTime(calendarDiv) : null,
                                    allDay : (function() {
                                        if (CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("getView").name === "month") {
                                            return (calendarDiv.data(CalendarPlugin.PREF_LAST_ALL_DAY_USED) || allDay.toString()) === "true";
                                        }
                                        return allDay;
                                    })()
                                },
                                null,
                                CalendarPlugin,
                                calendarDiv
                            ).show();
                        }
                    } else {
                        jsEvent.stopPropagation();
                        CalendarPlugin.hideInlineAuiDialogs();
                    }

                },
                eventClick : function(event, jsEvent) {
                    return ManageEvent(CalendarPlugin).eventClick(event, jsEvent, calendarDiv);
                },
                eventRender : function(event, eventDiv, view) {
                    ManageEvent(CalendarPlugin).eventRender(event, eventDiv, view, calendarDiv);
                },
                eventDrop : function(event, dayDelta, minuteDelta, allDay, revertFunc) {
                    ManageEvent(CalendarPlugin, cache).eventDrop(event, dayDelta, minuteDelta, allDay, revertFunc, calendarDiv);
                },
                eventDragStart : function() {
                    ManageEvent(CalendarPlugin, cache).eventDragStart(calendarDiv);
                },
                eventDragEnd : function() {
                    ManageEvent(CalendarPlugin, cache).eventDragEnd(calendarDiv);
                },
                eventResize : function(event, dayDelta, minuteDelta, revertFunc) {
                    ManageEvent(CalendarPlugin, cache).eventResize(event, dayDelta, minuteDelta, revertFunc, calendarDiv);
                },
                eventResizeStart : function() {
                    ManageEvent(CalendarPlugin, cache).eventResizeStart(calendarDiv);
                },
                eventResizeStop : function() {
                    ManageEvent(CalendarPlugin, cache).eventResizeStop(calendarDiv);
                },
                loading : function(isLoading) {
                    if (!isLoading) {
                        window.isTeamCalendarsLoaded = true;
                    }

                    if (!isLoading && this.spinnerDefer) {
                        this.spinnerDefer.resolve();
                    }

                    if (isLoading) {
                        this.spinnerDefer = CalendarPlugin.setSubCalendarSpinnerIconVisible(calendarDiv, isLoading);
                    }
                },
                selectable : true,
                selectHelper : true,
                select : function(startDate, endDate, allDay, jsEvent) {
                    if (!$(".event-details-popup:visible").length && CalendarPlugin.getSubCalendarsWhichCanAddEvents(calendarDiv).length) {
                        Confluence.TeamCalendars.Dialogs.getEditEventDialog({
                            start : startDate,
                            end : endDate,
                            localizedStartTime : allDay ? CalendarPlugin.getDefaultStartTime(calendarDiv) : null,
                            localizedEndTime : allDay ? CalendarPlugin.getDefaultEndTime(calendarDiv) : null,
                            allDay : (function() {
                                if (CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("getView").name === "month") {
                                    //for select multi-day event
                                    if(endDate.getTime() - startDate.getTime() > 0) {
                                        return allDay.toString() === "true";
                                    }
                                    return (calendarDiv.data(CalendarPlugin.PREF_LAST_ALL_DAY_USED) || allDay.toString()) === "true";
                                }
                                return allDay;
                            })()},
                            null,
                            CalendarPlugin,
                            calendarDiv).show();
                    } else {
                        if (jsEvent) {
                            jsEvent.stopPropagation();
                        }
                        CalendarPlugin.hideInlineAuiDialogs();
                    }
                }
            };
        };

        return FullCalendarOption;
    }
);