define("tc/customeventtype-view",
    [
        "jquery",
        "tc-backbone",
        "tc/dialogs",
        "tc/templates",
        "tc/customeventtype-edit",
        "tc/calendar-util"
    ],
    function (
        $,
        Backbone,
        Dialog,
        Templates,
        CustomEventTypeEditInlineDialogView,
        CalUtil
        )
    {
        "use strict";
        var CustomEventTypeView = Backbone.View.extend({
            tagName : "tr",
            mediator : null,
            confirmDialog : null,
            events: {
                "click .hidden-link" : "_toggle",
                "click .edit-eventtypes-link" : "_edit",
                "click .remove-eventtypes-link" : "_removeFromCollection"
            },
            initialize: function(option) {
                this.mediator = option.mediator;
                this.listenTo(this.model, "change", this.render);
                this.listenTo(this.model, 'destroy', this.remove);
                this.listenTo(this.model.collection, "selected" , this.selected);
            },
            render: function() {
                if (!this.$el.hasClass("event-type-item")){
                    this.$el.addClass("event-type-item");
                }

                if (this.model.get("disable")){
                    this.$el.addClass("event-type-item-hidden");
                }else {
                    this.$el.removeClass("event-type-item-hidden");
                }

                // remove tipsy before we change to new dom
                this.$el.find(".eventtypes-icon-link a").each(function(index, item){
                    var tipsy = $(item).data("tipsy");
                    if(tipsy) {
                        tipsy.disable();
                        tipsy.hide();
                    }
                });

                var modelObj = $.extend(
                    {}, this.model,
                    {
                        "showInforReminder" : CalUtil.showInforReminder(this.model.attributes.periodInMins)
                    }
                );

                this.$el.html(Confluence.TeamCalendars.Templates.viewCustomEventType({"eventTypeModel": modelObj}));

                 //add tooltip
                var $disableLink = this.$el.find(".eventtypes-icon-link a");
                if ($disableLink.tooltip)
                {
                    $disableLink.tooltip({aria:true});
                }

                return this;
            },
            removeEventListener : function (){
                this.$el.off('click', '.hide-eventtypes-link');
            },
            remove: function(){
                // detach from DOM
                this.$el.remove();
            },
            selected : function(collection){
                var selectedItem = collection.selectedItem();
                if (selectedItem.id === this.model.id) {
                    this._edit();
                }
            },
            _toggle: function(){
                this.model.toggle();
            },
            _edit: function() {
                var eventTypeEditDialogView = new CustomEventTypeEditInlineDialogView({model : this.model, parentCustomEventTypeDiv: this.$el, mediator : this.mediator});
                eventTypeEditDialogView.render();
                //scroll to bottom
                $("#edit-calendar-dialog").find(".eventtypes-edit-dialog-panel").scrollTop(eventTypeEditDialogView.$el.position().top);
            },
            _removeFromCollection: function(){
                var that = this;
                that.mediator.trigger("close-edit-custom-event-dialog");
                that._showConfirmCustomEventTypeDeleteDialog(that.model);
            },
            _getCustomEventTypeData: function(newCustomEventTypeModel) {
                return {
                    subCalendarId: newCustomEventTypeModel.get("subCalendar").id,
                    customEventTypeId: newCustomEventTypeModel.get("id")
                };
            },
            _showConfirmCustomEventTypeDeleteDialog: function(model) {
                var that = this;

                //bind escape when open confirm custom event type dialog
                function _bindEscapeCloseConfirmDialog(e) {
                   if (e.keyCode === 27) {
                       that._calltrigerOpenEditCustomEventTypeDialog(_bindEscapeCloseConfirmDialog);
                   }
                }
                $(document).keyup(_bindEscapeCloseConfirmDialog);

                var confirmCustomEventTypeDeleteDialog = new AJS.Dialog(450, "auto", "confirm-delete-custom-event-type");
                confirmCustomEventTypeDeleteDialog.addHeader(AJS.I18n.getText("calendar3.heading.confirmdeletecustomeventtype.title"));
                confirmCustomEventTypeDeleteDialog.addPanel(
                    "",
                    Confluence.TeamCalendars.Templates.confirmCustomEventNameDelete({"customEventName": model.get("title")}),
                    "tc-confirm-delete-custom-event-type-dialog");

                confirmCustomEventTypeDeleteDialog.addButton(AJS.I18n.getText("yes.name"), function () {
                    that._removeCustomEventType(model, confirmCustomEventTypeDeleteDialog, _bindEscapeCloseConfirmDialog);
                });

                confirmCustomEventTypeDeleteDialog.addLink(AJS.I18n.getText("cancel.name"), function () {
                    confirmCustomEventTypeDeleteDialog.hide();
                    that._calltrigerOpenEditCustomEventTypeDialog(_bindEscapeCloseConfirmDialog);
                    return false;
                });

                that.confirmDialog = confirmCustomEventTypeDeleteDialog;

                that.confirmDialog.show();
                that.confirmDialog.updateHeight();

                return confirmCustomEventTypeDeleteDialog;
            },
            _removeCustomEventType: function(model, confirmCustomEventTypeDeleteDialog, bindEscapeCloseConfirmDialog) {
                var that = this;
                var requestData = that._getCustomEventTypeData(model);
                //call rest to remove new custom event type
                $.ajax({
                    cache : false,
                    data : requestData,
                    dataType : "json",
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        confirmCustomEventTypeDeleteDialog.hide();
                    },
                    success : function() {
                        model.collection.remove(model);
                        confirmCustomEventTypeDeleteDialog.hide();
                        that._calltrigerOpenEditCustomEventTypeDialog(bindEscapeCloseConfirmDialog);

                        //analytic for delete a custom event type
                        var property = {
                            customEventTypeName: model.get("title")
                        };
                        Confluence.TeamCalendars.fireEventForAnalytics("customeventtype.delete", property);
                    },
                    type : "DELETE",
                    timeout: Confluence.TeamCalendars.ajaxTimeout,
                    url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/eventtype/custom.json")
                });
            },
            _calltrigerOpenEditCustomEventTypeDialog: function(bindEscapeCloseConfirmDialog) {
                this.mediator.trigger("open-edit-custom-event-dialog");
                if (this.confirmDialog)
                {
                    this.confirmDialog.hide();
                    this.confirmDialog.remove();
                }

                $(document).unbind("keyup", bindEscapeCloseConfirmDialog);
            }
        });

        return CustomEventTypeView;
    }
);