define("tc/subcalendar-navigation-buttons-view",
    [
        "jquery",
        "underscore",
        "tc/calendar-util",
        "tc/util",
        "tc/calendar-add-inline-dialog",
        "tc-backbone"
    ],
    function (
        $,
        _,
        CalUtil,
        Util,
        CalendarAddInlineDialogView,
        Backbone
    ) {

        var CalendarNavigationButtonsView = Backbone.View.extend({
            events: {
                "click .edit-calendar-button, #editCalendarLink" : "_onEditButtonClick",
                "click .add-calendar-button" : "_onAddButtonClick"
            },

            initialize: function(options) {
                this.calendarDiv = options.calendarDiv;
                this.CalendarPlugin = options.CalendarPlugin;

                AJS.bind("calendar.loaded", _.bind(this._onCalendarLoaded, this));
                AJS.bind("calendar.removed", _.bind(this._onCalendarRemoved, this));
                AJS.bind("calendar.watch.statuses.loaded", _.bind(this._onWatchStatusLoaded, this));

                this.inlineAddCalendarDialog = new CalendarAddInlineDialogView({callbackHandler: this.CalendarPlugin.getRenderedMacroCallbackHandler(this.calendarDiv)});

            },

            render: function() {
                // share button
                this._initShareButton();

                if (CalUtil.isSpaceCalendarView(this.calendarDiv)) {
                    // add calendar button
                    var hasCalendar = !$(".no-calendar-page").is(":visible");
                    this.$(".add-calendar-button").toggleClass("hidden", !hasCalendar);
                    this.$(".add-calendar-button-more").toggleClass("hidden", !hasCalendar);

                } else if(CalUtil.isSingleCalendarView(this.calendarDiv)) {
                    // edit button
                    if(this.subCalendar) {
                        var editable = this.CalendarPlugin.getParameter(this.calendarDiv, "readOnly") !== "true" && this.subCalendar.editable && this.subCalendar.eventsEditable;
                        this.$(".edit-calendar-button").toggleClass("hidden", !editable);
                    }
                }

                this.inlineAddCalendarDialog.render();
            },

            _initShareButton: function() {
                var hasCalendar = !$(".no-calendar-page").is(":visible");
                var enableShareCalendar = CalUtil.getParameter(this.calendarDiv, "enableShareCalendar");

                // should not show share when users do not have permission to view calendar
                var hasViewPermission = true;
                if(this.subCalendar) {
                    hasViewPermission = this.subCalendar.eventsViewable;
                }

                this.$(".share-calendar-button").toggleClass("hidden", !hasCalendar || !enableShareCalendar || !hasViewPermission);

                if (AJS.Confluence.SharePage && !this.shareDialogLoaded) {
                    AJS.Confluence.SharePage.initDialog($(".share-calendar-button"), "shareContentPopup", {offsetX: -110});
                    this.shareDialogLoaded = true;

                    var context = "spaceCalendars";
                    if(CalUtil.isSingleCalendarView(this.calendarDiv)){
                        context ="singleCalendar";
                    }
                    $(".share-calendar-button").click(function(event){
                        Confluence.TeamCalendars.fireEventForAnalytics("share.calendar.click." + context);
                    });
                }
            },

            _onEditButtonClick: function(event) {
                this.CalendarPlugin.showSubCalendarEdit(this.calendarDiv, this.subCalendar);
                //process behaviour when event type panel active
                $("#edit-calendar-dialog").find(".button-panel-button.submit").removeClass("hidden");

                event.preventDefault();

                return false;
            },

            _onCalendarLoaded: function(event, subCalendar) {
                // show/hide edit button in when calendar loaded in single view
                if(CalUtil.isSingleCalendarView(this.calendarDiv)) {
                    this.subCalendar = subCalendar;
                }

                var contentId = this.CalendarPlugin.getParameter(this.calendarDiv, "contentId");
                AJS.params.pageId = contentId ? contentId : AJS.params.pageId;

                this.render();
            },

            _onCalendarRemoved: function() {
                this.render();
            },

            _onWatchStatusLoaded: function(event, watchStatues) {
                //TODO: showing watch status of calendar
            },

            _onAddButtonClick: function(event) {
                Confluence.TeamCalendars.fireEventForAnalytics("add.calendar.click.new." + Confluence.TeamCalendars.getCalendarContext());
                var subCalendarDialog = Confluence.TeamCalendars.Dialogs.getSubCalendarCreateDialog("parent", this.CalendarPlugin.getRenderedMacroCallbackHandler(this.calendarDiv));
                Util.showDialogInUpdatedHeight(subCalendarDialog);
                $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
                $("#inline-dialog-inline-dialog-more").hide();

                event.preventDefault();

                return false;
            }
        });

        return CalendarNavigationButtonsView;
    }
);
