define("tc/calendar-reset-url-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util",
        "tc/util"
    ], function
        (
            $,
            _,
            Backbone,
            Templates,
            CalUtil,
            Util
            )
    {
        "use strict";
        var ResetUrlSubCalendarDialog = Backbone.View.extend({
            resetUrlSubCalendarDialog : null,
            calendarDiv: null,
            subCalendar: null,
            calendarPlugin : null,
            initialize: function(options){
                this.calendarDiv = options.calendarDiv;
                this.subCalendar = options.subCalendar;
                this.calendarPlugin = options.calendarPlugin;

                this.resetUrlSubCalendarDialog = $('#calendar-reset-private-urls-dialog');
            },
            render: function() {
                var that = this;
                if (this.resetUrlSubCalendarDialog) {
                    this.resetUrlSubCalendarDialog.remove();
                }

                var resetPrivateUrlsDialog = new AJS.Dialog({
                        width: 512,
                        height: 235,
                        id: "calendar-reset-private-urls-dialog"
                    }),
                    closeDialog = function() {
                        resetPrivateUrlsDialog.hide();
                        resetPrivateUrlsDialog.remove();
                    };

                resetPrivateUrlsDialog.addHeader(AJS.I18n.getText("calendar3.privateurl.reset.title"));
                resetPrivateUrlsDialog.addPanel("", Templates.resetSubCalendarPrivateUrl(), "calendar-private-url-reset-dialog-panel");

                var resetPrivateUrlsDialogBody =  resetPrivateUrlsDialog.getCurrentPanel().body;
                resetPrivateUrlsDialog.addButton(AJS.I18n.getText("calendar3.privateurl.reset.button.label"), function() {
                    var spinnerDefer = that.calendarPlugin.setSubCalendarSpinnerIconVisible(true);

                    var resetProgress = $(".reset-progress", resetPrivateUrlsDialogBody).addClass("reset-in-progress");
                    var resetButton = $("#calendar-reset-private-urls-dialog .subcalendar-private-url-reset-button").attr("disabled", "disabled");

                    $.ajax({
                        cache: false,
                        success: function() {
                            resetProgress.removeClass("reset-in-progress").addClass("reset-done");
                            $("#calendar-reset-private-urls-dialog .reset-cancel").text(AJS.I18n.getText("close.name"));
                            resetButton.removeAttr("disabled");
                        },
                        type: "PUT",
                        timeout : CalUtil.ajaxTimeout,
                        url: that.calendarPlugin.getCalendarServiceBaseUrl(that.calendarDiv, "/subcalendar/privateurl/reset/" + encodeURIComponent(that.subCalendar.id)),
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            resetButton.removeAttr("disabled");
                            CalUtil.showAjaxError(that.calendarDiv, XMLHttpRequest, textStatus, errorThrown,
                                that.calendarPlugin.ERROR_CLASS_RESET_PRIVATE_URLS);
                        },
                        complete: function(){
                            if(spinnerDefer) spinnerDefer.resolve();
                        }
                    });
                }, "subcalendar-private-url-reset-button");
                resetPrivateUrlsDialog.addLink(AJS.I18n.getText("cancel.name"), function() {
                    closeDialog();
                    return false;
                }, "reset-cancel");

                $(".calendar-title", resetPrivateUrlsDialogBody).text(that.subCalendar.name);
                $(".subscribe-to-calendar", resetPrivateUrlsDialogBody).click(function() {
                    closeDialog();
                    this.calendarPlugin.getSubCalendarIcalAddressDialog(that.calendarDiv, that.subCalendar).show();
                    return false;
                });
                resetPrivateUrlsDialog.show();

                return resetPrivateUrlsDialog;
            }

        });

        return ResetUrlSubCalendarDialog;
    });