define("tc/calendar-feature-discovery-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/dialogs",
        "tc/calendar-util",
        "tc/util"
    ], function
    (
        $,
        _,
        Backbone,
        Templates,
        Dialogs,
        CalUtil,
        Util
    )
    {
        "use strict";

        var CalendarFeatureDiscoveryDialog = Backbone.View.extend({
            featureDiscoveryDialog : null,
            calendarDiv: null,
            subCalendar: null,
            calendarPlugin : null,
            initialize: function(options){
                this.calendarDiv = options.calendarDiv;
                this.subCalendar = options.subCalendar;
                this.calendarPlugin = options.calendarPlugin;

                this.featureDiscoveryDialog = $('#team-calendars-feature-discovery-dialog');
            },
            render: function() {
                var that = this;

                if (this.featureDiscoveryDialog) {
                    this.featureDiscoveryDialog.remove();
                }

                var height = CalUtil.isPDLEnabled() ? 385 : 340,
                    discoveryDialog = new AJS.Dialog({width: 596, height: height, id: "team-calendars-feature-discovery-dialog"});

                discoveryDialog.addHeader(AJS.I18n.getText("calendar3.featurediscovery.title"));
                discoveryDialog.addPanel(
                    "",
                    Templates.subCalendarFeatures(
                        {
                            "autoConvertSupported" : CalUtil.getParameter(this.calendarDiv, "autoConvertSupported") === "true",
                            "subCalendar" : this.subCalendar
                        }),
                    "setup-calendar-panel"
                );

                var dialogBody = discoveryDialog.getCurrentPanel().body;

                //Add event panel
                $(".add-event", dialogBody).click(function() {
                    discoveryDialog.remove();
                    var dialog = Dialogs.getEditEventDialog(
                        {
                            start : new Date(),
                            localizedStartTime : that.calendarPlugin.getDefaultStartTime(that.calendarDiv),
                            localizedEndTime : that.calendarPlugin.getDefaultEndTime(that.calendarDiv),
                            allDay : (that.calendarDiv.data(that.calendarPlugin.PREF_LAST_ALL_DAY_USED) || "true") === "true",
                            subCalendarId : that.subCalendar.id
                        },
                        that.subCalendar,
                        that.calendarPlugin,
                        that.calendarDiv
                    );
                    dialog.show();

                    return false;
                });

                //Restrictions panel
                $(".restrict", dialogBody).click(function() {
                    discoveryDialog.remove();
                    that.calendarPlugin.getSubCalendarRestrictionsDialog(that.calendarDiv, that.subCalendar).show();
                    return false;
                });

                //Share panel
                $(".embed, .embed-or-share, .share", dialogBody).click(function() {
                    discoveryDialog.remove();
                    var shareDialog = that.calendarPlugin.getSubCalendarShareDialog(that.calendarDiv, that.subCalendar);
                    shareDialog.show();
                    $(".share-address-field", shareDialog.getCurrentPanel().body).focus().select();

                    return false;
                });

                discoveryDialog.addLink(AJS.I18n.getText("close.name"), function() {
                    discoveryDialog.remove();
                });

                discoveryDialog.show();
            }
        });

        return CalendarFeatureDiscoveryDialog;
    });