define("tc/calendar-add-inline-dialog",
    [
        "jquery",
        "tc-backbone",
        "tc/templates",
        "tc/dialogs",
        "tc/util"
    ],
    function (
        $,
        Backbone,
        Templates,
        Dialogs,
        Util) {
    "use strict";

    var CalendarAddInlineDialogView = Backbone.View.extend({

        initialize: function(options) {
            options = options || {};
            this.callbackHandler = options.callbackHandler;
        },

        hide: function() {
            this.dialog.hide();
        },

        render: function () {

            var handler = this.callbackHandler;
            if (!this.dialog) {
                this.dialog = AJS.InlineDialog($("#inline-dialog-more"), "inline-dialog-more", function (content, trigger, showPopup) {
                    content.html(Templates.addInlineDialog());

                    content.find(".option-new").on("click", function() {
                        var subCalendarDialog = Dialogs.getSubCalendarCreateDialog("parent", handler);
                        Util.showDialogInUpdatedHeight(subCalendarDialog);
                        $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
                        $("#inline-dialog-more").removeClass("active");
                        $("#inline-dialog-inline-dialog-more").hide();
                        Confluence.TeamCalendars.fireEventForAnalytics("add.calendar.click.new." + Confluence.TeamCalendars.getCalendarContext());
                    });

                    content.find(".option-import").on("click", function() {
                        var subCalendarDialog = Dialogs.getSubCalendarImportDialog(handler);
                        Util.showDialogInUpdatedHeight(subCalendarDialog);
                        $("input[name='name']", subCalendarDialog.getCurrentPanel()).focus();
                        $("#inline-dialog-more").removeClass("active");
                        $("#inline-dialog-inline-dialog-more").hide();
                        Confluence.TeamCalendars.fireEventForAnalytics("add.calendar.click.import." + Confluence.TeamCalendars.getCalendarContext());
                    });

                    content.find(".option-existing").on("click", function() {
                        var inPage = $("meta[name='ajs-page-id']").length >= 1;

                        var subCalendarSubscribeDialog = Dialogs.getSubCalendarSubscribeDialog(
                            $.extend({
                                callbackHandler: handler,
                                heading: inPage ? AJS.I18n.getText("calendar3.searchcalendars") : AJS.I18n.getText("calendar3.popularcalendars"),
                                showSearch: inPage,
                                searchParams: {
                                    "showSubCalendarsInView": AJS.Meta.get("space-key") !== undefined || inPage
                                },
                                disableWatching: inPage,
                                id: "internal-subscription-calendar-dialog"
                            })
                        );
                        Util.showDialogInUpdatedHeight(subCalendarSubscribeDialog);
                        $("#inline-dialog-more").removeClass("active");
                        $("#inline-dialog-inline-dialog-more").hide();
                        Confluence.TeamCalendars.fireEventForAnalytics("add.calendar.click.existing." + Confluence.TeamCalendars.getCalendarContext());
                    });

                    content.find(".option-subscription").on("click", function() {
                        var subCalendarDialog = Dialogs.getSubCalendarCreateDialog("subscription", handler);
                        Util.showDialogInUpdatedHeight(subCalendarDialog);
                        $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
                        $("#inline-dialog-more").removeClass("active");
                        $("#inline-dialog-inline-dialog-more").hide();
                        Confluence.TeamCalendars.fireEventForAnalytics("add.calendar.click.subscribe." + Confluence.TeamCalendars.getCalendarContext());
                    });

                    showPopup();
                    return false;
                });
            }
        }
    });

    return CalendarAddInlineDialogView;
});
