define("tc/auto-complete-search-helper",
    [
        "jquery",
        "tc/calendar-util"
    ], function
        (
            $,
            CalUtil
        )
    {
        "use strict";
        return {
            makeAutoCompleteSearch : function(calendarDiv, searchField, searchOptions, suggestionsContainer, suggestionClickHandler, resultFilter) {
                searchField.keydown(function(event) {
                    var selectedSuggestion = $("li.active", suggestionsContainer);

                    if (27 == event.keyCode) {
                        if (!suggestionsContainer.hasClass("hidden")) {
                            suggestionsContainer.addClass("hidden");
                            return false;
                        }
                    }

                    // keyup
                    if (38 == event.keyCode) {
                        if (!suggestionsContainer.hasClass("hidden")) {
                            if (selectedSuggestion.length) {
                                if (selectedSuggestion.prev().length)
                                    selectedSuggestion.removeClass("active").prev().addClass("active");
                            } else {
                                $(".aui-dropdown li:last", suggestionsContainer).addClass("active");
                            }
                            return false;
                        }
                    }

                    // keydown
                    if (40 == event.keyCode) {
                        if (!suggestionsContainer.hasClass("hidden")) {
                            if (selectedSuggestion.length) {
                                if (selectedSuggestion.next().length)
                                    selectedSuggestion.removeClass("active").next().addClass("active");
                            } else {
                                $(".aui-dropdown li:first", suggestionsContainer).addClass("active");
                            }
                            return false;
                        }
                        return false;
                    }

                    if (13 == event.keyCode) {
                        if (!suggestionsContainer.hasClass("hidden")) {
                            $(".aui-dropdown li.active a", suggestionsContainer).trigger("click");
                            return false;
                        }
                    }

                    if ($.trim(searchField.val())) {
                        setTimeout(function() {
                            if (!$.trim(searchField.val())) {
                                suggestionsContainer.addClass("hidden");
                                return;
                            }

                            $.ajax({
                                cache : false,
                                data : $.extend({
                                    search : "name",
                                    query : searchField.val()
                                }, searchOptions),
                                dataType : "json",
                                error : function(XMLHttpRequest, textStatus, errorThrown) {
                                    if (XMLHttpRequest.status !== 400) {
                                        // 400 is invalid search query - but we just want to swallow
                                        // it since the user may be typing a wiki link (which would be result in this error)
                                        CalUtil.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown);
                                    }
                                },
                                success : function(searchResult) {
                                    var suggestionList = $(document.createElement("ol"));
                                    var getHtmlLink = function(_result) {
                                        return result.id ? CalUtil.getParameter(calendarDiv, "baseUrl") + "/pages/viewpage.action?pageId=" + encodeURIComponent(_result.id) : "#";
                                    };

                                    for (var groupIdx = 0; groupIdx < searchResult.group.length; ++groupIdx) {
                                        var theGroup = searchResult.group[groupIdx];
                                        if (theGroup.result) {
                                            for (var resultIdx = 0; resultIdx < theGroup.result.length; ++resultIdx) {
                                                var result = theGroup.result[resultIdx];

                                                if (resultFilter && !resultFilter(result))
                                                    continue;

                                                var suggestion = $(document.createElement("li")).mouseover(function() {
                                                    $("li.active", suggestionsContainer).removeClass("active");
                                                    $(this).addClass("active");
                                                });

                                                if (result.thumbnailLink) {
                                                    $(document.createElement("img"))
                                                        .attr("src", result.thumbnailLink.href)
                                                        .appendTo(suggestion);
                                                }

                                                if (result.link && result.link.length) {
                                                    $(document.createElement("span"))
                                                        .attr("title", result.title || (result.space ? " " + result.space.name : ""))
                                                        .text(result.title)
                                                        .appendTo(
                                                        $(document.createElement("a"))
                                                            .data("result", result)
                                                            .attr("href", getHtmlLink(result) || "")
                                                            .addClass(result.type ? "content-type-" + result.type : "")
                                                            .click(function() {
                                                                if (suggestionClickHandler)
                                                                    suggestionClickHandler(searchField, $(this));
                                                                suggestionsContainer.addClass("hidden");
                                                                return false;
                                                            })
                                                            .appendTo(suggestion)
                                                    );
                                                }

                                                suggestion.appendTo(suggestionList);
                                            }
                                        }
                                    }

                                    if (suggestionList.children().length) {
                                        // We probably do not want too many results
                                        $("li", suggestionList).each(function(index) {
                                            if (index > 4)
                                                $(this).remove();
                                        });
                                        $(".aui-dropdown", suggestionsContainer).empty().append(suggestionList);
                                        suggestionsContainer.removeClass("hidden").dropDown("Standard");
                                    } else {
                                        suggestionsContainer.addClass("hidden");
                                    }
                                },
                                timeout: CalUtil.ajaxTimeout,
                                url : CalUtil.getParameter(calendarDiv, "baseUrl") + "/rest/prototype/1/search.json"
                            })
                        }, 300);
                    }
                }).focus(function() {
                    if (searchField.hasClass("with-hint"))
                        searchField.removeClass("with-hint").val("");
                }).blur(function() {
                    if (!$.trim(searchField.val()))
                        searchField.addClass("with-hint").val(AJS.I18n.getText("calendar3.eventlink.pageorblogpost"));
                });
            }
        }
    });
