/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.lucenecompat.impl;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.labs.lucenecompat.impl.Lucene4FieldDescriptorMapper;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

public class Lucene4AdaptingExtractor
implements Extractor {
    private final Extractor2 delegate;
    private final Lucene4FieldDescriptorMapper fieldDescriptorMapper;

    public Lucene4AdaptingExtractor(Extractor2 delegate) {
        this.delegate = delegate;
        this.fieldDescriptorMapper = new Lucene4FieldDescriptorMapper();
    }

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        StringBuilder buffer;
        Collection fieldDescriptors = this.delegate.extractFields((Object)searchable);
        if (fieldDescriptors != null) {
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                Object field = this.fieldDescriptorMapper.map(fieldDescriptor);
                if (!(field instanceof IndexableField)) continue;
                document.add((IndexableField)field);
            }
        }
        if ((buffer = this.delegate.extractText((Object)searchable)) != null) {
            defaultSearchableText.append(' ').append((CharSequence)buffer);
        }
    }
}

