/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.trustedapps;

import com.atlassian.plugin.StateAware;
import com.atlassian.sal.core.trusted.CertificateFactory;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedAppsPluginCertificateFactory
implements CertificateFactory,
StateAware {
    private static final Logger log = LoggerFactory.getLogger(TrustedAppsPluginCertificateFactory.class);
    private static final String TRUSTED_APPLICATIONS_MANAGER = "com.atlassian.security.auth.trustedapps.TrustedApplicationsManager";
    private ServiceTracker serviceTracker;
    private final BundleContext bundleContext;

    public TrustedAppsPluginCertificateFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceTracker = new ServiceTracker(bundleContext, TRUSTED_APPLICATIONS_MANAGER, null);
        this.serviceTracker.open();
    }

    @Override
    public EncryptedCertificate createCertificate(String username) {
        throw new UnsupportedOperationException("Not implemented. Since v2.10.9 Trusted Apps requires a url for its signature");
    }

    @Override
    public EncryptedCertificate createCertificate(String username, String url) {
        if (this.serviceTracker != null) {
            try {
                TrustedApplicationsManager trustedApplicationsManager = (TrustedApplicationsManager)this.serviceTracker.getService();
                if (trustedApplicationsManager != null) {
                    return trustedApplicationsManager.getCurrentApplication().encode(username, url);
                }
            }
            catch (NoClassDefFoundError trustedApplicationsManager) {
            }
            catch (ClassCastException cce) {
                log.warn("A TrustedApplicationsManager was found, but a ClassCastException was thrown when attempting to cast it. This is possible if TrustedApplicationsManager has been uninstalled and installed", (Throwable)cce);
            }
        }
        throw new UnsupportedOperationException("Trusted apps support is not installed.");
    }

    public void enabled() {
        if (this.serviceTracker == null) {
            this.serviceTracker = new ServiceTracker(this.bundleContext, TRUSTED_APPLICATIONS_MANAGER, null);
            this.serviceTracker.open();
        }
    }

    public void disabled() {
        this.serviceTracker.close();
        this.serviceTracker = null;
    }
}

