/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net.auth;

import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import java.io.Serializable;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedTokenScheme
implements ContextAwareAuthScheme,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(TrustedTokenScheme.class);
    private final CertificateCopy certificate;

    public TrustedTokenScheme(EncryptedCertificate certificate) {
        this.certificate = new CertificateCopy(certificate);
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        request.addHeader("X-Seraph-Trusted-App-ID", this.certificate.getID());
        request.addHeader("X-Seraph-Trusted-App-Cert", this.certificate.getCertificate());
        request.addHeader("X-Seraph-Trusted-App-Key", this.certificate.getSecretKey());
        Integer version = this.certificate.getProtocolVersion();
        if (version != null) {
            request.addHeader("X-Seraph-Trusted-App-Version", version.toString());
        }
        request.addHeader("X-Seraph-Trusted-App-Magic", this.certificate.getMagicNumber());
        if (this.certificate.getSignature() != null) {
            request.addHeader("X-Seraph-Trusted-App-Signature", this.certificate.getSignature());
        }
        return null;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        log.warn("Ignoring a call to processChallenge as TrustedTokenScheme is intended for preemptive authentication only.");
    }

    public String getSchemeName() {
        return "trustedtoken";
    }

    public String getParameter(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRealm() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, (HttpContext)new BasicHttpContext());
    }

    private static final class CertificateCopy
    implements EncryptedCertificate,
    Serializable {
        private final String id;
        private final String certificate;
        private final String secretKey;
        private final Integer protocolVersion;
        private final String magicNumber;
        private final String signature;

        public CertificateCopy(EncryptedCertificate cert) {
            this.id = cert.getID();
            this.certificate = cert.getCertificate();
            this.secretKey = cert.getSecretKey();
            this.protocolVersion = cert.getProtocolVersion();
            this.magicNumber = cert.getMagicNumber();
            this.signature = cert.getSignature();
        }

        public String getID() {
            return this.id;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public Integer getProtocolVersion() {
            return this.protocolVersion;
        }

        public String getMagicNumber() {
            return this.magicNumber;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

