/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.api.net.TrustedRequest;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.net.auth.TrustedTokenScheme;
import com.atlassian.sal.core.trusted.CertificateFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpClientTrustedRequest
extends HttpClientRequest
implements TrustedRequest {
    private final UserManager userManager;
    private final CertificateFactory certificateFactory;

    public HttpClientTrustedRequest(UserManager userManager, CertificateFactory certificateFactory, CloseableHttpClient httpClient, HttpClientContext httpClientContext, Request.MethodType initialMethodType, String initialUrl) {
        super(httpClient, httpClientContext, initialMethodType, initialUrl);
        this.userManager = userManager;
        this.certificateFactory = certificateFactory;
    }

    public HttpClientTrustedRequest addTrustedTokenAuthentication(String hostname) {
        return this.addTrustedTokenAuthentication(hostname, this.userManager.getRemoteUsername());
    }

    public HttpClientTrustedRequest addTrustedTokenAuthentication(String hostname, String username) {
        this.httpClientContext.getCredentialsProvider().setCredentials(new AuthScope(hostname, -1), (Credentials)new UsernamePasswordCredentials(username, null));
        this.httpClientContext.getAuthCache().put(new HttpHost(hostname), (AuthScheme)new TrustedTokenScheme(this.certificateFactory.createCertificate(username, this.requestBuilder.getUri().toString())));
        return this;
    }

    public void execute(ResponseHandler responseHandler) throws ResponseException {
        super.execute(responseHandler);
    }

    public Object executeAndReturn(ReturningResponseHandler responseHandler) throws ResponseException {
        return super.executeAndReturn(responseHandler);
    }
}

