/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.license;

import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseLicenseDetailsImpl
implements BaseLicenseDetails {
    private final ConfluenceLicense confluenceLicense;

    public BaseLicenseDetailsImpl(@Nonnull ConfluenceLicense confluenceLicense) {
        this.confluenceLicense = confluenceLicense;
    }

    protected ConfluenceLicense getConfluenceLicense() {
        return this.confluenceLicense;
    }

    public boolean isEvaluationLicense() {
        return this.confluenceLicense.isEvaluation();
    }

    @Nonnull
    public String getLicenseTypeName() {
        return this.confluenceLicense.getLicenseType().name();
    }

    public String getOrganisationName() {
        return this.confluenceLicense.getOrganisation().getName();
    }

    @Nullable
    public String getSupportEntitlementNumber() {
        return this.confluenceLicense.getSupportEntitlementNumber();
    }

    public String getDescription() {
        return this.confluenceLicense.getDescription();
    }

    public String getServerId() {
        return this.confluenceLicense.getServerId();
    }

    public boolean isPerpetualLicense() {
        return false;
    }

    @Nullable
    public Date getLicenseExpiryDate() {
        return this.confluenceLicense.getExpiryDate();
    }

    @Nullable
    public Date getMaintenanceExpiryDate() {
        return this.confluenceLicense.getMaintenanceExpiryDate();
    }

    public boolean isDataCenter() {
        return this.confluenceLicense.isClusteringEnabled();
    }

    public boolean isEnterpriseLicensingAgreement() {
        throw new UnsupportedOperationException("Cannot detect whether confluence license is ELA");
    }

    @Nullable
    public String getProperty(@Nonnull String key) {
        return this.confluenceLicense.getProperty(key);
    }
}

