/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.TextNodeParser;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.TextNode;
import java.io.IOException;
import java.util.Map;

public class UnreferencedAnchorNode
extends Node {
    private static StringBuilder builder = new StringBuilder(512);
    private String text;

    public UnreferencedAnchorNode(String text) {
        builder.setLength(0);
        char[] array = text.toCharArray();
        for (int index = 0; index < array.length; ++index) {
            char ch = array[index];
            if (ch == '\n') {
                if (array[index - 1] == ' ') continue;
                builder.append(' ');
                continue;
            }
            builder.append(ch);
        }
        this.text = builder.toString();
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        AnchorNode node = referenceLinks.get(this.text);
        if (node == null) {
            builder.append('[');
            TextNode textNode = new TextNodeParser().parse(this, this.text);
            textNode.write(builder, false, referenceLinks, options);
            builder.append(']');
            return;
        }
        AnchorNode newAnchor = new AnchorNode(null, this.text, node.getUrl(), node.getTitle(), false, 0);
        newAnchor.write(builder, atRootNode, referenceLinks, options);
    }
}

