/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.TextNode;
import java.io.IOException;
import java.util.Map;

public class SpecialCharacterNode
extends TextNode {
    private char character;

    public SpecialCharacterNode(Node parent, char ch) {
        super(parent);
        this.character = ch;
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        builder.append(this.toString());
    }

    public char getCharacter() {
        return this.character;
    }

    public void setCharacter(char character) {
        if (character == '\n') {
            throw new IllegalArgumentException("Use NewLineNode instead.");
        }
        this.character = character;
    }

    public String toString() {
        switch (this.character) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt";
            }
            case '\n': {
                return "";
            }
        }
        return String.valueOf(this.character);
    }
}

