/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RootNode
extends Node {
    private final Map<String, AnchorNode> referenceLinks = new HashMap<String, AnchorNode>();

    public String toString() {
        StringBuilder b = new StringBuilder(1024);
        b.append("ROOT\n");
        for (Map.Entry<String, AnchorNode> entry : this.referenceLinks.entrySet()) {
            b.append(entry.getKey());
            b.append(": ");
            b.append(entry.getValue().getUrl());
            b.append('\n');
        }
        return b.toString();
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        if (this.children != null && this.children.size() > 0) {
            for (Node node : this.children) {
                node.write(builder, true, this.referenceLinks, options);
            }
        }
    }

    public void addReferenceLink(String id, String link, String title) {
        this.referenceLinks.put(id, new AnchorNode(null, null, link, title, false, 0));
    }

    public AnchorNode getLink(String id) {
        return this.referenceLinks.get(id);
    }

    public Map<String, AnchorNode> getReferenceLinks() {
        return this.referenceLinks;
    }
}

