/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.HeadingNode;
import com.sangupta.nutz.ast.HtmlCommentNode;
import com.sangupta.nutz.ast.NewLineNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.PlainTextNode;
import com.sangupta.nutz.ast.TextNode;
import com.sangupta.nutz.ast.XmlNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class ParagraphNode
extends TextNode {
    public ParagraphNode(Node parent) {
        super(parent);
    }

    public ParagraphNode(Node parent, String text) {
        super(parent);
        this.add(new PlainTextNode(parent, text));
    }

    public void addChild(TextNode node) {
        this.add(node);
    }

    public boolean breakIntoTextAndHeading(int headingStyle) {
        Node node;
        while ((node = this.lastNode()) instanceof NewLineNode) {
            this.children.remove(node);
        }
        this.parent.replaceNode(this, new HeadingNode(headingStyle, this));
        return true;
    }

    private void add(TextNode node) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(node);
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        Node firstNode = this.firstNode();
        if (atRootNode && (firstNode instanceof HtmlCommentNode || firstNode instanceof XmlNode)) {
            atRootNode = false;
        }
        if (this.children.size() == 1) {
            if (atRootNode) {
                builder.append("<p>");
            }
            ((Node)this.children.get(0)).write(builder, atRootNode, referenceLinks, options);
            if (firstNode instanceof XmlNode) {
                builder.append(NEW_LINE);
                builder.append(NEW_LINE);
            }
            if (atRootNode) {
                builder.append("</p>");
                builder.append(NEW_LINE);
                builder.append(NEW_LINE);
            }
            return;
        }
        boolean paraStart = false;
        if (atRootNode) {
            builder.append("<p>");
            paraStart = true;
        }
        for (int index = 0; index < this.children.size(); ++index) {
            Node node = (Node)this.children.get(index);
            if (node instanceof NewLineNode && index + 2 < this.children.size() && this.children.get(index + 1) instanceof NewLineNode) {
                builder.append("</p>");
                builder.append(NEW_LINE);
                builder.append("<p>");
                ++index;
                continue;
            }
            if (node instanceof ParagraphNode) {
                if (paraStart) {
                    builder.append("</p>");
                    builder.append(NEW_LINE);
                    builder.append(NEW_LINE);
                }
                builder.append("<p>");
                paraStart = true;
            }
            node.write(builder, atRootNode, referenceLinks, options);
        }
        if (atRootNode && paraStart) {
            builder.append("</p>");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[PARA: ");
        if (this.children != null) {
            for (Node node : this.children) {
                b.append(node.toString());
                b.append(",");
            }
        }
        b.append("]");
        return b.toString();
    }
}

