/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.RootNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Node {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    protected List<Node> children = null;

    public void addChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot add a null child node.");
        }
        if (node instanceof RootNode) {
            throw new IllegalArgumentException("Cannot add a type of root node.");
        }
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(node);
    }

    public boolean hasChild() {
        return this.children != null && !this.children.isEmpty();
    }

    public Node firstNode() {
        if (this.hasChild()) {
            return this.children.get(0);
        }
        return null;
    }

    public Node lastNode() {
        if (this.hasChild()) {
            return this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public void replaceNode(Node oldNode, Node newNode) {
        for (int index = 0; index < this.children.size(); ++index) {
            Node node = this.children.get(index);
            if (node != oldNode) continue;
            this.children.add(index, newNode);
            this.children.remove(oldNode);
        }
    }

    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        builder.append(this.toString());
    }

    public List<Node> getChildren() {
        return this.children;
    }
}

