/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AbstractListNode;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.NewLineNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.TextNode;
import java.io.IOException;
import java.util.Map;

public class ListItemNode
extends TextNode {
    private boolean looseItems = false;

    public ListItemNode(Node parent) {
        super(parent);
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        Node lastNode;
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        while ((lastNode = this.lastNode()) instanceof NewLineNode) {
            this.children.remove(lastNode);
        }
        if (this.looseItems) {
            builder.append("<p>");
        }
        boolean alreadyClosed = false;
        for (int index = 0; index < this.children.size(); ++index) {
            Node node = (Node)this.children.get(index);
            if (node instanceof AbstractListNode) {
                if (this.looseItems) {
                    builder.append("</p>");
                    alreadyClosed = true;
                }
            } else if (this.looseItems && alreadyClosed) {
                builder.append("<p>");
                alreadyClosed = false;
            }
            node.write(builder, atRootNode, referenceLinks, options);
            if (!(node instanceof NewLineNode) || index + 1 >= this.children.size() || !(this.children.get(index + 1) instanceof NewLineNode) || this.children.get(index + 2) instanceof AbstractListNode) continue;
            builder.append("</p>");
            builder.append(NEW_LINE);
            builder.append("<p>");
            ++index;
        }
        if (this.looseItems && !alreadyClosed) {
            builder.append("</p>");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[PARA: ");
        if (this.children != null) {
            for (Node node : this.children) {
                b.append(node.toString());
                b.append(",");
            }
        }
        b.append("]");
        return b.toString();
    }

    public void setLooseItems(boolean looseItems) {
        this.looseItems = looseItems;
    }
}

