/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.HtmlEscapeUtils;
import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.TextNode;
import java.io.IOException;
import java.util.Map;

public class InlineCodeNode
extends TextNode {
    private String code;

    public InlineCodeNode(Node parent, String code) {
        super(parent);
        this.code = code;
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        builder.append("<code>");
        HtmlEscapeUtils.writeEscapedLine(this.code, builder);
        builder.append("</code>");
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return "Code: " + this.code;
    }
}

