/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import java.io.IOException;
import java.util.Map;

public class ImageNode
extends Node {
    private String url;
    private String alternateText;
    private String title;
    private boolean onID;

    public ImageNode(String url, String alternateText, boolean onID) {
        this.url = url;
        this.alternateText = alternateText;
        this.onID = onID;
    }

    public ImageNode(String url, String alternateText, String title) {
        this(url, alternateText, false);
        this.title = title;
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        AnchorNode node;
        if (this.onID && (node = referenceLinks.get(this.url)) != null) {
            this.url = node.getUrl();
            this.title = node.getTitle();
        }
        builder.append("<img src=\"");
        builder.append(this.url);
        builder.append("\"");
        if (this.alternateText != null) {
            builder.append(" alt=\"");
            builder.append(this.alternateText);
            builder.append("\"");
        }
        if (this.title == null) {
            this.title = "";
        }
        if (!this.onID || !this.title.isEmpty()) {
            builder.append(" title=\"");
            builder.append(this.title);
            builder.append("\"");
        }
        builder.append(" />");
    }

    public String toString() {
        return "IMAGE: " + this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }
}

