/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import java.io.IOException;
import java.util.Map;

public class HeadingNode
extends Node {
    private int headCount;
    private Node textNode;

    public HeadingNode(int headCount, Node text) {
        this.headCount = headCount;
        this.textNode = text;
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        builder.append("<h");
        builder.append(Integer.toString(this.headCount));
        builder.append(">");
        this.textNode.write(builder, false, referenceLinks, options);
        builder.append("</h");
        builder.append(Integer.toString(this.headCount));
        builder.append(">");
        builder.append(NEW_LINE);
        builder.append(NEW_LINE);
    }

    public String toString() {
        return "HEADING: " + this.textNode.toString();
    }

    public int getHeadCount() {
        return this.headCount;
    }

    public Node getTextNode() {
        return this.textNode;
    }
}

