/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.HtmlEscapeUtils;
import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.util.PepmintUtil;
import java.io.IOException;
import java.util.Map;

public class CodeBlockNode
extends Node {
    private String language;
    private String code;

    public CodeBlockNode(String code, String lang) {
        this.code = code;
        this.language = lang;
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        boolean needsEscaping = true;
        boolean addClosingTags = true;
        String formattedCode = this.code;
        ProcessingOptions.SyntaxHighlightingOption option = options.syntaxHighlightingOption;
        if (this.language == null) {
            option = ProcessingOptions.SyntaxHighlightingOption.None;
        }
        switch (option) {
            case SyntaxHighlighter: {
                builder.append("<pre class=\"brush: ");
                builder.append(this.language);
                builder.append("\"><code>");
                break;
            }
            case Pepmint: {
                needsEscaping = false;
                addClosingTags = false;
                formattedCode = PepmintUtil.highlight(formattedCode, this.language);
                break;
            }
            case None: {
                builder.append("<pre><code>");
            }
        }
        if (needsEscaping) {
            HtmlEscapeUtils.writeEscapedLine(formattedCode, builder);
        } else {
            builder.append(formattedCode);
        }
        if (addClosingTags) {
            builder.append("</code></pre>");
        }
        builder.append(NEW_LINE);
        builder.append(NEW_LINE);
    }

    public String toString() {
        return "CODE: [" + this.language + "]=" + this.code;
    }
}

