/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.HtmlEscapeUtils;
import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.TextNodeParser;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.TextNode;
import java.io.IOException;
import java.util.Map;

public class AnchorNode
extends TextNode {
    private TextNode text;
    private String url;
    private String title;
    private boolean onID;
    private int spaces;

    public AnchorNode(Node parent, String url) {
        super(parent);
        this.text = null;
        this.url = url;
        this.title = null;
    }

    public AnchorNode(Node parent, String text, String url, String title, boolean onID, int spaces) {
        super(parent);
        if (text != null) {
            TextNode node;
            this.text = node = new TextNodeParser().parse(this, text);
        }
        this.url = url;
        this.title = title;
        this.onID = onID;
        this.spaces = spaces;
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        if (this.onID) {
            String identifier = this.url.isEmpty() ? this.text.getPlainText() : this.url;
            AnchorNode anchor = referenceLinks.get(identifier);
            if (anchor == null) {
                builder.append('[');
                this.text.write(builder, false, referenceLinks, options);
                builder.append(']');
                for (int i = 0; i < this.spaces; ++i) {
                    builder.append(' ');
                }
                builder.append('[');
                builder.append(this.url);
                builder.append(']');
                return;
            }
            this.url = anchor.getUrl();
            this.title = anchor.getTitle();
        }
        builder.append("<a href=\"");
        builder.append(this.url);
        builder.append("\"");
        if (this.title != null) {
            builder.append(" title=\"");
            HtmlEscapeUtils.writeEscapedLine(this.title, builder);
            builder.append("\"");
        }
        builder.append(">");
        if (this.text != null) {
            this.text.write(builder, false, referenceLinks, options);
        } else {
            builder.append(this.url);
        }
        builder.append("</a>");
    }

    public String toString() {
        return "[ANCHOR: " + this.url + "]";
    }

    public TextNode getText() {
        return this.text;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }
}

