/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz.ast;

import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.ListItemNode;
import com.sangupta.nutz.ast.Node;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractListNode
extends Node {
    private String tagName;
    private boolean looseItems = false;

    protected AbstractListNode(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public void addChild(Node node) {
        if (!(node instanceof ListItemNode)) {
            throw new IllegalArgumentException("Only list item nodes can be added.");
        }
        ((ListItemNode)node).setLooseItems(this.looseItems);
        super.addChild(node);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(1024);
        b.append(this.tagName);
        b.append(":\n");
        for (Node node : this.children) {
            b.append(node.toString());
            b.append("\n");
        }
        return b.toString();
    }

    @Override
    public void write(Appendable builder, boolean atRootNode, Map<String, AnchorNode> referenceLinks, ProcessingOptions options) throws IOException {
        builder.append('<');
        builder.append(this.tagName);
        builder.append('>');
        builder.append(NEW_LINE);
        if (this.hasChild()) {
            for (Node node : this.children) {
                builder.append("<li>");
                node.write(builder, true, referenceLinks, options);
                builder.append("</li>");
                builder.append(NEW_LINE);
            }
        }
        builder.append("</");
        builder.append(this.tagName);
        builder.append('>');
        builder.append(NEW_LINE);
        builder.append(NEW_LINE);
    }

    public void setLooseItems(boolean looseItems) {
        this.looseItems = looseItems;
    }
}

