/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz;

import com.sangupta.nutz.Identifiers;
import com.sangupta.nutz.MarkupUtils;
import com.sangupta.nutz.ast.AnchorNode;
import com.sangupta.nutz.ast.EmailNode;
import com.sangupta.nutz.ast.EmphasisNode;
import com.sangupta.nutz.ast.HtmlCommentNode;
import com.sangupta.nutz.ast.ImageNode;
import com.sangupta.nutz.ast.InlineCodeNode;
import com.sangupta.nutz.ast.NewLineNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.ParagraphNode;
import com.sangupta.nutz.ast.PlainTextNode;
import com.sangupta.nutz.ast.SpecialCharacterNode;
import com.sangupta.nutz.ast.StrongNode;
import com.sangupta.nutz.ast.TextNode;
import com.sangupta.nutz.ast.UnreferencedAnchorNode;
import com.sangupta.nutz.ast.XmlNode;
import java.util.Arrays;

public class TextNodeParser
implements Identifiers {
    private String line;
    private int lastConverted;
    private int pos;
    private int length;
    private TextNode root = null;

    public TextNode parse(Node parent, String line) {
        return this.parse(parent, new ParagraphNode(parent), line);
    }

    public TextNode parse(Node parent, TextNode rootNode, String line) {
        this.line = line;
        this.length = line.length();
        this.pos = 0;
        this.lastConverted = 0;
        this.root = rootNode;
        this.parse();
        this.root = null;
        return rootNode;
    }

    private void parse() {
        do {
            if (this.charAt(this.pos, '\n')) {
                this.clearPending();
                this.root.addChild(new NewLineNode(this.root));
                this.lastConverted = ++this.pos;
                continue;
            }
            if (this.charAt(this.pos, '\\')) {
                this.clearPending();
                ++this.pos;
                ++this.lastConverted;
            }
            if (this.charAt(this.pos, '<')) {
                this.clearPending();
                if (this.charAt(this.pos + 1, '!') && this.charAt(this.pos + 2, '-') && this.charAt(this.pos + 3, '-')) {
                    this.parseInlineHTMLComment();
                } else {
                    this.parseHtmlOrAutoLinkBlock();
                }
            }
            if (this.charAt(this.pos, '`') && !this.charAt(this.pos - 1, '\\')) {
                this.clearPending();
                this.parseCharacterBlock('`');
            }
            if (this.charAt(this.pos, '!') && this.charAt(this.pos + 1, '[')) {
                this.clearPending();
                this.parseImageBlock();
            }
            if (this.charAt(this.pos, '[') && !this.charAt(this.pos - 1, '\\')) {
                this.clearPending();
                this.parseLink();
            }
            if (this.charAt(this.pos, '*') && !this.charAt(this.pos - 1, '\\')) {
                this.clearPending();
                this.parseCharacterBlock('*');
            }
            if (this.charAt(this.pos, '_') && !this.charAt(this.pos - 1, '\\')) {
                this.clearPending();
                this.parseCharacterBlock('_');
            }
            this.handleSpecialCharacters();
            ++this.pos;
        } while (this.pos < this.line.length());
        this.clearPending();
    }

    private void handleSpecialCharacters() {
        if (this.pos >= this.length) {
            return;
        }
        char character = this.line.charAt(this.pos);
        boolean conversion = false;
        switch (character) {
            case '&': {
                if (this.line.length() < this.pos + 5 || this.line.substring(this.pos + 1, this.pos + 5).equals("amp;")) break;
                conversion = true;
                break;
            }
            case '<': 
            case '>': {
                conversion = true;
            }
        }
        if (conversion) {
            this.clearPending();
            this.root.addChild(new SpecialCharacterNode(this.root, character));
            ++this.pos;
            this.lastConverted = this.pos;
        }
    }

    private void parseInlineHTMLComment() {
        int index = this.pos + 3;
        if ((index = this.line.indexOf("-->", index)) == -1) {
            return;
        }
        String text = this.line.substring(this.pos, index + 3);
        this.root.addChild(new HtmlCommentNode(text));
        this.lastConverted = this.pos = index + 3;
    }

    private void parseHtmlOrAutoLinkBlock() {
        int index = this.line.indexOf(62, this.pos + 1);
        if (index == -1) {
            return;
        }
        String markup = this.line.substring(this.pos + 1, index);
        if (MarkupUtils.isHyperLink(markup)) {
            this.root.addChild(new AnchorNode(this.root, markup));
            this.lastConverted = this.pos = index + 1;
            return;
        }
        if (MarkupUtils.isEmail(markup)) {
            this.root.addChild(new EmailNode(markup));
            this.lastConverted = this.pos = index + 1;
            return;
        }
        String tagName = this.extractTagName(markup);
        index = MarkupUtils.findEndingTagPosition(this.line, this.pos + tagName.length(), tagName);
        if (index == -1) {
            if (MarkupUtils.isSingularHtmlElement(tagName)) {
                index = this.line.indexOf(62, this.pos + tagName.length()) + 1;
            } else {
                return;
            }
        }
        this.root.addChild(new XmlNode(this.line.substring(this.pos, index)));
        this.lastConverted = this.pos = index;
    }

    private String extractTagName(String markup) {
        int index = markup.indexOf(32);
        if (index != -1) {
            markup = markup.substring(0, index);
        }
        if (markup.endsWith("/")) {
            markup = markup.substring(0, markup.length() - 1);
        }
        return markup;
    }

    private void parseImageBlock() {
        int index = this.line.indexOf(93, this.pos + 2);
        if (index == -1) {
            return;
        }
        String alternateText = this.line.substring(this.pos + 2, index);
        this.pos = ++index;
        char ch = this.line.charAt(index++);
        while (ch == ' ') {
            ch = this.line.charAt(index++);
        }
        if (ch != '(' && ch != '[') {
            return;
        }
        if (ch == '(') {
            if ((index = MarkupUtils.indexOfSkippingForPairCharacter(this.line, ')', '(', index)) == -1) {
                return;
            }
            String link = this.line.substring(this.pos + 1, index);
            String[] tokens = MarkupUtils.parseLinkAndTitle(link);
            this.root.addChild(new ImageNode(tokens[0], alternateText, tokens[1]));
        } else if (ch == '[') {
            if ((index = this.line.indexOf(93, index + 1)) == -1) {
                return;
            }
            String identifier = this.line.substring(this.pos + 1, index);
            this.root.addChild(new ImageNode(identifier, alternateText, true));
        }
        this.lastConverted = this.pos = index + 1;
    }

    private void parseLink() {
        int index = MarkupUtils.indexOfSkippingForPairCharacter(this.line, ']', '[', this.pos + 1);
        if (index == -1) {
            return;
        }
        String linkText = this.line.substring(this.pos + 1, index);
        this.pos = ++index;
        if (index >= this.line.length()) {
            this.root.addChild(new UnreferencedAnchorNode(linkText));
            this.lastConverted = this.pos = index;
            return;
        }
        char ch = this.line.charAt(index++);
        int spaceCount = 0;
        while ((ch == ' ' || ch == '\n') && index < this.line.length()) {
            ch = this.line.charAt(index++);
            ++spaceCount;
        }
        if (ch != '(' && ch != '[') {
            this.root.addChild(new UnreferencedAnchorNode(linkText));
            this.lastConverted = this.pos = index - 1 - spaceCount;
            return;
        }
        this.pos += spaceCount;
        if (ch == '(') {
            if ((index = MarkupUtils.indexOfSkippingForPairCharacter(this.line, ')', '(', index)) == -1) {
                return;
            }
            String link = this.line.substring(this.pos + 1, index);
            String[] tokens = MarkupUtils.parseLinkAndTitle(link);
            AnchorNode anchorNode = new AnchorNode(this.root, linkText.trim(), tokens[0].trim(), tokens[1], false, spaceCount);
            this.root.addChild(anchorNode);
        } else if (ch == '[') {
            if ((index = this.line.indexOf(93, index)) == -1) {
                return;
            }
            String identifier = this.line.substring(this.pos + 1, index);
            AnchorNode anchorNode = new AnchorNode(this.root, linkText.trim(), identifier, null, true, spaceCount);
            this.root.addChild(anchorNode);
        }
        this.lastConverted = this.pos = index + 1;
    }

    private void parseCharacterBlock(char terminator) {
        char c;
        int count = 1;
        int index = 1;
        while ((c = this.line.charAt(this.pos + index)) == terminator) {
            ++index;
            ++count;
        }
        index = this.pos + count;
        int endCount = 0;
        int indexMultiple = MarkupUtils.indexOfMultiple(this.line, terminator, count, index);
        if (indexMultiple != -1) {
            index = indexMultiple;
            endCount = count;
        } else {
            block7: {
                do {
                    char c2;
                    if ((c2 = this.line.charAt(index)) == '\\') {
                        ++index;
                        continue;
                    }
                    if (c2 == terminator) break block7;
                } while (++index < this.length);
                index = -1;
            }
            if (index == -1) {
                this.convertCharacterBlock(count, terminator);
                this.pos += count;
                this.lastConverted = this.pos;
                return;
            }
            endCount = 1;
            int checkIndex = 0;
            while ((checkIndex = index + endCount) != this.length && this.line.charAt(checkIndex) == terminator) {
                ++endCount;
            }
        }
        String text = this.line.substring(this.pos + count, index);
        this.convertCharacterBlock(count, endCount, text, terminator);
        this.lastConverted = this.pos = index + endCount;
    }

    private void convertCharacterBlock(int startCount, int endCount, String text, char terminator) {
        switch (terminator) {
            case '*': 
            case '_': {
                if (startCount != endCount) break;
                switch (startCount) {
                    case 1: {
                        this.root.addChild(new EmphasisNode(this.root, text));
                        return;
                    }
                    case 2: {
                        this.root.addChild(new StrongNode((Node)this.root, text));
                        return;
                    }
                    case 3: {
                        StrongNode strongNode = new StrongNode(this.root);
                        EmphasisNode emphasisNode = new EmphasisNode(strongNode, text);
                        strongNode.setTextNode(emphasisNode);
                        this.root.addChild(strongNode);
                        return;
                    }
                }
                break;
            }
            case '`': {
                this.root.addChild(new InlineCodeNode(this.root, text.trim()));
                return;
            }
        }
        System.out.println("*** Unhandled: " + text + ":" + startCount + ", " + endCount);
    }

    private void convertCharacterBlock(int count, char terminator) {
        if (count <= 2) {
            char[] array = new char[count];
            Arrays.fill(array, terminator);
            if (this.root.hasChild() && this.root.lastNode() instanceof PlainTextNode) {
                PlainTextNode node = (PlainTextNode)this.root.lastNode();
                node.appendText(String.valueOf(array));
            } else {
                this.root.addChild(new PlainTextNode(this.root, String.valueOf(array)));
            }
            return;
        }
        System.out.println("FIX THIS!!!");
    }

    private void clearPending() {
        if (this.pos > this.length) {
            this.pos = this.length;
        }
        if (this.lastConverted + 1 <= this.pos) {
            String text = this.line.substring(this.lastConverted, this.pos);
            if ("\n".equals(text)) {
                this.root.addChild(new NewLineNode(this.root));
            } else {
                this.root.addChild(new PlainTextNode(this.root, text));
            }
        }
        this.lastConverted = this.pos;
    }

    private boolean charAt(int pos, char character) {
        if (pos < 0) {
            return false;
        }
        return pos < this.line.length() && this.line.charAt(pos) == character;
    }
}

